/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.jpdl;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.dom4j.Element;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.State;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.ProblemListener;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.sim.action.ProcessEndAction;
import org.jbpm.sim.action.ProcessStartAction;
import org.jbpm.sim.action.StartTaskAndPlanCompletion;
import org.jbpm.sim.def.DistributionDefinition;
import org.jbpm.sim.exe.ExperimentReader;
import org.jbpm.sim.jpdl.SimulationDefinition;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.xml.sax.InputSource;

public class SimulationJpdlXmlReader
extends JpdlXmlReader {
    private static final long serialVersionUID = 1L;

    public SimulationJpdlXmlReader(String processXml) {
        this(new InputSource(new StringReader(processXml)));
    }

    public SimulationJpdlXmlReader(InputSource inputSource) {
        this(inputSource, null);
    }

    public SimulationJpdlXmlReader(Reader reader) {
        this(new InputSource(reader));
    }

    public SimulationJpdlXmlReader(InputSource inputSource, ProblemListener problemListener) {
        super(inputSource, problemListener);
    }

    public ProcessDefinition readProcessDefinition() {
        ProcessDefinition result = super.readProcessDefinition();
        this.instrument();
        return result;
    }

    private SimulationDefinition getSimulationDefinition() {
        SimulationDefinition simulationDefinition = (SimulationDefinition)this.processDefinition.getDefinition(SimulationDefinition.class);
        if (simulationDefinition == null) {
            simulationDefinition = new SimulationDefinition();
            this.processDefinition.addDefinition((ModuleDefinition)simulationDefinition);
        }
        return simulationDefinition;
    }

    public void instrument() {
        Element rootElement = this.document.getRootElement();
        SimulationDefinition simulationDefinition = this.getSimulationDefinition();
        Iterator poolElementIter = rootElement.elementIterator("resource-pool");
        while (poolElementIter.hasNext()) {
            Element resourcePoolElement = (Element)poolElementIter.next();
            String poolName = resourcePoolElement.attributeValue("name");
            String poolSizeText = resourcePoolElement.attributeValue("pool-size");
            Integer poolSize = new Integer(poolSizeText);
            Double costPerTimeUnit = this.readCostPerTimeUnit(resourcePoolElement);
            simulationDefinition.addResourcePool(poolName, poolSize, costPerTimeUnit);
        }
        Iterator swimlaneElementIter = rootElement.elementIterator("swimlane");
        while (swimlaneElementIter.hasNext()) {
            Element swimlaneElement = (Element)swimlaneElementIter.next();
            if (swimlaneElement.attributeValue("pool-size") == null) continue;
            String poolName = swimlaneElement.attributeValue("name");
            String poolSizeText = swimlaneElement.attributeValue("pool-size");
            Integer poolSize = new Integer(poolSizeText);
            Double costPerTimeUnit = this.readCostPerTimeUnit(swimlaneElement);
            simulationDefinition.addResourcePool(poolName, poolSize, costPerTimeUnit);
        }
        Iterator distributionIterator = rootElement.elementIterator("distribution");
        while (distributionIterator.hasNext()) {
            Element distributionElement = (Element)distributionIterator.next();
            DistributionDefinition distDef = ExperimentReader.readDistribution(distributionElement);
            simulationDefinition.addDistribution(distDef);
        }
        Event taskAssignEvent = new Event("task-create");
        this.processDefinition.addEvent(taskAssignEvent);
        taskAssignEvent.addAction((Action)new StartTaskAndPlanCompletion());
        Event processStartEvent = new Event("before-signal");
        this.processDefinition.getStartState().addEvent(processStartEvent);
        processStartEvent.addAction((Action)new ProcessStartAction());
        Event processEndEvent = new Event("process-end");
        this.processDefinition.addEvent(processEndEvent);
        processEndEvent.addAction((Action)new ProcessEndAction());
        simulationDefinition.setStartDistribution(rootElement.attributeValue("start-distribution"));
    }

    private Double readCostPerTimeUnit(Element resourcePoolElement) {
        String costPerTimeUnitText = resourcePoolElement.attributeValue("costs-per-time-unit");
        if (costPerTimeUnitText != null) {
            return Double.valueOf(costPerTimeUnitText);
        }
        return new Double(0.0);
    }

    public Task readTask(Element taskElement, TaskMgmtDefinition taskMgmtDefinition, TaskNode taskNode) {
        Task task = super.readTask(taskElement, taskMgmtDefinition, taskNode);
        String distributionName = taskElement.attributeValue("time-distribution");
        this.getSimulationDefinition().addTaskDistribution(task, distributionName);
        if (task.getSwimlane() != null) {
            this.getSimulationDefinition().addResourceRequirement(task, task.getSwimlane().getName(), 1);
        }
        this.readResourceUsages(taskElement, task);
        return task;
    }

    public void readNode(Element nodeElement, Node node, NodeCollection nodeCollection) {
        super.readNode(nodeElement, node, nodeCollection);
        if (State.class.isAssignableFrom(node.getClass())) {
            String distributionName = nodeElement.attributeValue("time-distribution");
            this.getSimulationDefinition().addStateDistribution(node, distributionName);
            this.readResourceUsages(nodeElement, node);
        }
    }

    private void readResourceUsages(Element xmlElement, Object processElement) {
        Iterator iter = xmlElement.elementIterator("resource-needed");
        while (iter.hasNext()) {
            Element resourceElement = (Element)iter.next();
            String poolName = resourceElement.attributeValue("pool");
            String amountText = resourceElement.attributeValue("amount");
            int amount = 1;
            if (amountText != null) {
                amount = Integer.parseInt(amountText);
            }
            this.getSimulationDefinition().addResourceRequirement(processElement, poolName, amount);
        }
    }

    public Transition resolveTransitionDestination(Element transitionElement, Node node) {
        Transition trans = super.resolveTransitionDestination(transitionElement, node);
        String probString = transitionElement.attributeValue("probability");
        if (probString != null) {
            double prob = Double.parseDouble(probString);
            this.getSimulationDefinition().addTransitionProbability(trans, prob);
        }
        return trans;
    }
}

