/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.def;

import desmoj.core.report.MessageReceiver;
import desmoj.core.report.Reporter;
import desmoj.core.simulator.Experiment;
import desmoj.core.simulator.SimTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.sim.datasource.ProcessDataFilter;
import org.jbpm.sim.datasource.ProcessDataSource;
import org.jbpm.sim.def.DefaultJbpmSimulationModel;
import org.jbpm.sim.def.DistributionDefinition;
import org.jbpm.sim.def.JbpmSimulationExperiment;
import org.jbpm.sim.def.JbpmSimulationModel;
import org.jbpm.sim.event.StatisticsResetEvent;
import org.jbpm.sim.exception.ExperimentConfigurationException;
import org.jbpm.sim.jpdl.SimulationDefinition;
import org.jbpm.sim.kpi.BusinessFigure;
import org.jbpm.sim.report.InMemoryOutput;
import org.jbpm.sim.report.ScenarioReport;

public class JbpmSimulationScenario {
    private String name;
    private boolean execute = true;
    private List processDefinitions = new ArrayList();
    private List businessFigures = new ArrayList();
    private JbpmSimulationModel model = null;
    private ScenarioReport scenarioReport;
    static final String DATE_PATTERN = "dd.MM.yyyy HH:mm:ss:SSS";

    public JbpmSimulationScenario() {
        this(null);
    }

    public JbpmSimulationScenario(String name) {
        this.name = name == null ? "DefaultScenario" : name;
    }

    public void changeName(String name) {
        this.name = name;
    }

    public void addProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinitions.add(processDefinition);
    }

    public void addDistribution(DistributionDefinition distDef) {
        for (ProcessDefinition pd : this.processDefinitions) {
            SimulationDefinition def = (SimulationDefinition)pd.getDefinition(SimulationDefinition.class);
            def.overwriteDistribution(distDef);
        }
    }

    public void addResourcePool(String poolName, Integer poolSize, Double costPerTimeUnit) {
        for (ProcessDefinition pd : this.processDefinitions) {
            SimulationDefinition def = (SimulationDefinition)pd.getDefinition(SimulationDefinition.class);
            def.overwriteResourcePool(poolName, poolSize, costPerTimeUnit);
        }
    }

    public void runSimulation(JbpmSimulationExperiment jbpmExperiment, boolean writeHtmlReport, boolean rememberEndedProcessInstances) {
        this.runSimulation(jbpmExperiment, writeHtmlReport, rememberEndedProcessInstances, 0L);
    }

    public void runSimulation(JbpmSimulationExperiment jbpmExperiment, boolean writeHtmlReport, boolean rememberEndedProcessInstances, long seed) {
        String reportOutputType = null;
        if (writeHtmlReport) {
            reportOutputType = Experiment.DEFAULT_REPORT_OUTPUT_TYPE;
        }
        Experiment desmojExperiment = new Experiment(jbpmExperiment.getName() + "." + this.getName(), jbpmExperiment.getOutputPathName(), new SimpleDateFormat(DATE_PATTERN).format(jbpmExperiment.getRealStartDate()), jbpmExperiment.getTimeUnit(), reportOutputType, null, Experiment.DEFAULT_ERROR_OUTPUT_TYPE, null);
        if (seed != 0L) {
            desmojExperiment.setSeedGenerator(seed);
        }
        InMemoryOutput report = new InMemoryOutput();
        desmojExperiment.addReceiver((MessageReceiver)report, Reporter.class);
        DefaultJbpmSimulationModel model = new DefaultJbpmSimulationModel(this.processDefinitions.toArray(new ProcessDefinition[0]));
        model.setRememberEndedProcessInstances(rememberEndedProcessInstances);
        model.connectToExperiment(desmojExperiment);
        if (jbpmExperiment.getResetTime() > 0.0) {
            StatisticsResetEvent evt = new StatisticsResetEvent(model);
            evt.schedule(new SimTime(jbpmExperiment.getResetTime()));
        }
        for (BusinessFigure figure : this.businessFigures) {
            model.addBusinessFigure(figure.copy());
        }
        desmojExperiment.stop(new SimTime(jbpmExperiment.getSimulationRunTime()));
        desmojExperiment.setShowProgressBar(false);
        desmojExperiment.start();
        desmojExperiment.report();
        this.scenarioReport = report.getReport();
        desmojExperiment.finish();
        this.model = rememberEndedProcessInstances ? model : null;
    }

    public void persist(JbpmContext ctx) {
        for (ProcessDefinition pd : this.processDefinitions) {
            ctx.deployProcessDefinition(pd);
        }
        for (ProcessInstance pi : this.model.getEndedProcessInstances()) {
            ctx.save(pi);
        }
    }

    public String getName() {
        return this.name;
    }

    public ScenarioReport getScenarioReport() {
        return this.scenarioReport;
    }

    public boolean isExecute() {
        return this.execute;
    }

    public void setExecute(boolean execute) {
        this.execute = execute;
    }

    public void addBusinessFigure(BusinessFigure figure) {
        this.businessFigures.add(figure);
    }

    public void addDataSource(String name, String className) {
        ProcessDataSource src = null;
        try {
            src = (ProcessDataSource)Class.forName(className).newInstance();
        }
        catch (Throwable ex) {
            throw new ExperimentConfigurationException("Couldn't initialize data source '" + name + "' of type '" + className + "'", ex);
        }
        this.addDataSource(name, src);
    }

    public void addDataSource(String name, ProcessDataSource src) {
        for (ProcessDefinition pd : this.processDefinitions) {
            SimulationDefinition def = (SimulationDefinition)pd.getDefinition(SimulationDefinition.class);
            def.addDataSource(name, src);
        }
    }

    public void addDataFilter(String name, String className) {
        ProcessDataFilter filter = null;
        try {
            filter = (ProcessDataFilter)Class.forName(className).newInstance();
        }
        catch (Throwable ex) {
            throw new ExperimentConfigurationException("Couldn't initialize data filter '" + name + "' of type '" + className + "'", ex);
        }
        this.addDataFilter(name, filter);
    }

    public void addDataFilter(String name, ProcessDataFilter filter) {
        for (ProcessDefinition pd : this.processDefinitions) {
            SimulationDefinition def = (SimulationDefinition)pd.getDefinition(SimulationDefinition.class);
            def.addDataFilter(name, filter);
        }
    }

    public List getProcessDefinitions() {
        return this.processDefinitions;
    }

    public List getEndedProcessInstances() {
        return this.model.getEndedProcessInstances();
    }
}

