/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.bam;

import java.util.Calendar;
import java.util.Date;
import org.hibernate.Query;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.GetProcessDefinitionCommand;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.sim.bam.BamSimulationProposal;
import org.jbpm.sim.bam.ElementStatistics;
import org.jbpm.sim.bam.TransitionProbability;

public class GetSimulationInputCommand
extends GetProcessDefinitionCommand {
    private Date fromTimeOfDay;
    private Date tillTimeOfDay;

    public GetSimulationInputCommand() {
    }

    public GetSimulationInputCommand(String name) {
        super(name);
    }

    public GetSimulationInputCommand(String name, int version) {
        super(name, version);
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        ProcessDefinition pd = (ProcessDefinition)super.execute(jbpmContext);
        BamSimulationProposal result = new BamSimulationProposal(this.getName(), this.getVersion());
        result.setSwimlanes(pd.getTaskMgmtDefinition().getSwimlanes().keySet().toArray(new String[0]));
        this.queryProcessStatistics(jbpmContext, pd, result);
        this.queryStateStatistics(jbpmContext, pd, result);
        this.queryDecisionStatistics(jbpmContext, pd, result);
        this.queryTaskInstanceStatistics(jbpmContext, pd, result);
        this.queryDecisionStatistics(jbpmContext, pd, result);
        return result;
    }

    private void queryProcessStatistics(JbpmContext jbpmContext, ProcessDefinition pd, BamSimulationProposal result) {
        Query decisionQuery = jbpmContext.getSession().getNamedQuery("Simulation.calculateProcessInstanceStartInterval");
        decisionQuery.setTime("fromTime", this.fromTimeOfDay);
        decisionQuery.setTime("tillTime", this.tillTimeOfDay);
        decisionQuery.setLong("processDefinitionId", pd.getId());
        Object[] o = (Object[])decisionQuery.uniqueResult();
        if (o == null) {
            throw new JbpmException("no logs found for process " + pd);
        }
        ElementStatistics statistics = new ElementStatistics(pd.getName());
        statistics.setSampleCount((Long)o[0]);
        statistics.setDurationAverage((Double)o[1]);
        statistics.setDurationMin(((Double)o[2]).longValue());
        statistics.setDurationMax(((Double)o[3]).longValue());
        statistics.setDurationStddev((Double)o[4]);
        result.setProcessStatistics(statistics);
    }

    private void queryDecisionStatistics(JbpmContext jbpmContext, ProcessDefinition pd, BamSimulationProposal result) {
        Query decisionQuery = jbpmContext.getSession().getNamedQuery("Simulation.calculateAverageTimeForDecisions");
        decisionQuery.setTime("fromTime", this.fromTimeOfDay);
        decisionQuery.setTime("tillTime", this.tillTimeOfDay);
        decisionQuery.setEntity("processDefinition", (Object)pd);
        for (Object[] o : decisionQuery.list()) {
            long decisionId = (Long)o[0];
            String decisionName = (String)o[1];
            ElementStatistics statistics = new ElementStatistics(decisionName);
            statistics.setSampleCount((Long)o[2]);
            statistics.setDurationAverage((Double)o[3]);
            statistics.setDurationMin(((Long)o[4]).longValue());
            statistics.setDurationMax(((Long)o[5]).longValue());
            statistics.setDurationStddev((Double)o[6]);
            this.queryTransitionProbabilities(jbpmContext, decisionId, statistics);
            result.addDecisionProposal(statistics);
        }
    }

    private void queryStateStatistics(JbpmContext jbpmContext, ProcessDefinition pd, BamSimulationProposal result) {
        Query nodeQuery = null;
        nodeQuery = jbpmContext.getSession().getNamedQuery("Simulation.calculateAverageTimeForStates");
        nodeQuery.setTime("fromTime", this.fromTimeOfDay);
        nodeQuery.setTime("tillTime", this.tillTimeOfDay);
        nodeQuery.setEntity("processDefinition", (Object)pd);
        for (Object[] o : nodeQuery.list()) {
            long stateId = (Long)o[0];
            String nodeName = (String)o[1];
            ElementStatistics statistics = new ElementStatistics(nodeName);
            statistics.setSampleCount((Long)o[2]);
            statistics.setDurationAverage((Double)o[3]);
            statistics.setDurationMin(((Long)o[4]).longValue());
            statistics.setDurationMax(((Long)o[5]).longValue());
            statistics.setDurationStddev((Double)o[6]);
            this.queryTransitionProbabilities(jbpmContext, stateId, statistics);
            result.addStateProposal(statistics);
        }
    }

    private void queryTaskInstanceStatistics(JbpmContext jbpmContext, ProcessDefinition pd, BamSimulationProposal result) {
        Query nodeQuery = null;
        nodeQuery = jbpmContext.getSession().getNamedQuery("Simulation.calculateAverageTimeForTaskInstances");
        nodeQuery.setTime("fromTime", this.fromTimeOfDay);
        nodeQuery.setTime("tillTime", this.tillTimeOfDay);
        nodeQuery.setLong("processDefinitinId", pd.getId());
        for (Object[] o : nodeQuery.list()) {
            long taskNodeId = (Long)o[0];
            String taskName = (String)o[2];
            ElementStatistics statistics = new ElementStatistics(taskName);
            statistics.setSampleCount((Long)o[3]);
            statistics.setDurationAverage((Double)o[4]);
            statistics.setDurationMin((Double)o[5]);
            statistics.setDurationMax((Double)o[6]);
            statistics.setDurationStddev((Double)o[7]);
            this.queryTransitionProbabilities(jbpmContext, taskNodeId, statistics);
            result.addTaskProposal(statistics);
        }
    }

    private void queryTransitionProbabilities(JbpmContext jbpmContext, long nodeId, ElementStatistics statistics) {
        Query transQuery = jbpmContext.getSession().getNamedQuery("Simulation.calculateLeavingTransitionProbability");
        transQuery.setLong("nodeId", nodeId);
        transQuery.setTime("fromTime", this.fromTimeOfDay);
        transQuery.setTime("tillTime", this.tillTimeOfDay);
        for (Object[] probs : transQuery.list()) {
            String transitionName = (String)probs[1];
            long count = (Long)probs[4];
            statistics.addTransitionProbability(new TransitionProbability(transitionName, count));
        }
    }

    public static void main(String[] args) throws Exception {
        JbpmContext ctx = JbpmConfiguration.getInstance((String)"org/jbpm/sim/bam/jbpm.cfg.xml").createJbpmContext();
        GetSimulationInputCommand cmd = new GetSimulationInputCommand();
        cmd.setName("RegisterDomain");
        cmd.setVersion(6);
        Calendar cal1 = Calendar.getInstance();
        cal1.set(0, 0, 0, 18, 0);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(0, 0, 0, 22, 35);
        cmd.setFromTimeOfDay(cal1.getTime());
        cmd.setTillTimeOfDay(cal2.getTime());
        BamSimulationProposal result = (BamSimulationProposal)cmd.execute(ctx);
        BamSimulationProposal.print(result);
    }

    public Date getFromTimeOfDay() {
        return this.fromTimeOfDay;
    }

    public void setFromTimeOfDay(Date fromTimeOfDay) {
        this.fromTimeOfDay = fromTimeOfDay;
    }

    public Date getTillTimeOfDay() {
        return this.tillTimeOfDay;
    }

    public void setTillTimeOfDay(Date tillTimeOfDay) {
        this.tillTimeOfDay = tillTimeOfDay;
    }
}

