/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.entity;

import desmoj.core.simulator.Model;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.sim.def.ResourceRequirement;
import org.jbpm.sim.entity.ResourceUsingEntity;
import org.jbpm.sim.event.WorkCompletionEvent;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class TaskInstanceEntity
extends ResourceUsingEntity {
    private static Log log = LogFactory.getLog(TaskInstanceEntity.class);
    private TaskInstance taskInstance;

    public TaskInstanceEntity(Model owner, TaskInstance taskInstance) {
        super(owner, "TaskInstance " + taskInstance, true);
        this.taskInstance = taskInstance;
    }

    public Object getEntityObject() {
        return this.taskInstance.getTask();
    }

    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    protected void doStart() {
        this.startTaskAndScheduleCompletion();
    }

    public void startTaskAndScheduleCompletion() {
        this.taskInstance.start();
        log.info((Object)("ask the simulation clock to complete task " + this.taskInstance.getName() + " whenever it feels like it"));
        WorkCompletionEvent evt = new WorkCompletionEvent(this.getModel());
        evt.schedule(this, this.getJbpmModel().getTaskWorkingTime(this.taskInstance.getTask()));
    }

    protected ResourceRequirement[] getRequiredResources() {
        return this.getJbpmModel().getResourceRequirements(this.taskInstance.getTask());
    }

    public void doEnd() {
        this.taskInstance.end(this.getJbpmModel().getLeavingTransition(this.taskInstance.getToken().getNode()));
    }
}

