/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.graph.def.Transition;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class CompleteTaskActionListener
implements JbpmActionListener {
    private final ValueExpression taskInstanceExpression;
    private final ValueExpression transitionExpression;

    public CompleteTaskActionListener(ValueExpression taskInstanceExpression, ValueExpression transitionExpression) {
        this.taskInstanceExpression = taskInstanceExpression;
        this.transitionExpression = transitionExpression;
    }

    public String getName() {
        return "completeTask";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object taskInstanceValue = this.taskInstanceExpression.getValue(elContext);
            if (taskInstanceValue == null) {
                context.setError("Error completing task", "The task instance value is null");
                return;
            }
            if (!(taskInstanceValue instanceof TaskInstance)) {
                context.setError("Error completing task", "Attempted to complete something other than a task instance");
                return;
            }
            TaskInstance taskInstance = (TaskInstance)taskInstanceValue;
            if (this.transitionExpression != null) {
                Object transitionValue = this.transitionExpression.getValue(elContext);
                if (transitionValue == null) {
                    taskInstance.end();
                } else if (transitionValue instanceof Transition) {
                    taskInstance.end((Transition)transitionValue);
                } else {
                    String transitionName = transitionValue.toString();
                    taskInstance.end(transitionName);
                }
            } else {
                taskInstance.end();
            }
            context.addSuccessMessage("Task completed");
            context.getJbpmContext().getSession().flush();
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error completing task", ex);
            return;
        }
    }
}

