/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.PhaseId;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class LoadTaskActionListener
implements JbpmActionListener {
    private final ValueExpression idExpression;
    private final ValueExpression targetExpression;
    private final ValueExpression forUpdateExpression;

    public LoadTaskActionListener(ValueExpression idExpression, ValueExpression targetExpression, ValueExpression forUpdateExpression) {
        this.idExpression = idExpression;
        this.targetExpression = targetExpression;
        this.forUpdateExpression = forUpdateExpression;
    }

    public String getName() {
        return "loadTask";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            boolean forUpdate;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object idValue = this.idExpression.getValue(elContext);
            if (idValue == null) {
                context.setError("Error loading task instance", "The ID value is null");
                return;
            }
            long id = idValue instanceof Long ? ((Long)idValue).longValue() : Long.valueOf(idValue.toString()).longValue();
            if (this.forUpdateExpression != null) {
                Object forUpdateValue = this.forUpdateExpression.getValue(elContext);
                if (forUpdateValue == null) {
                    context.setError("Error loading task instance", "The value of 'forUpdate' is null");
                    return;
                }
                forUpdate = forUpdateValue instanceof Boolean ? (Boolean)forUpdateValue : Boolean.parseBoolean(forUpdateValue.toString());
            } else {
                forUpdate = event.getPhaseId() != PhaseId.RENDER_RESPONSE;
            }
            TaskInstance taskInstance = forUpdate ? context.getJbpmContext().getTaskInstanceForUpdate(id) : context.getJbpmContext().getTaskInstance(id);
            if (taskInstance == null) {
                context.setError("Error loading task instance", "No task instance was found with an ID of " + id);
                return;
            }
            this.targetExpression.setValue(elContext, (Object)taskInstance);
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error loading task", ex);
            return;
        }
    }
}

