/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jbpm.jsf.core.config.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationLocator {
    private final List<Configuration.FileMatcher> matchers = ConfigurationLocator.arrayList();
    private boolean useJsfActorId;
    private static Configuration configuration = null;
    private static final Map<String, Elem> elements;
    private static final Logger log;

    private static <T> List<T> arrayList() {
        return new ArrayList();
    }

    private ConfigurationLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getInstance() {
        Class<ConfigurationLocator> clazz = ConfigurationLocator.class;
        synchronized (ConfigurationLocator.class) {
            if (configuration == null) {
                ConfigurationLocator configurationLocator = new ConfigurationLocator();
                configurationLocator.configure();
                configuration = new Configuration(configurationLocator.matchers, configurationLocator.useJsfActorId);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return configuration;
        }
    }

    private void configure() throws FacesException {
        this.searchJars();
        this.searchWar();
    }

    private Elem lookup(Element element) {
        Elem elem = elements.get(element.getLocalName());
        if (elem == null) {
            throw this.unexpectedElement(element);
        }
        return elem;
    }

    private Iterable<Element> childrenOf(Element element) {
        return new ElementIterable(element);
    }

    private RuntimeException unexpectedElement(Element element) {
        return new IllegalStateException("Unexpected element \"" + element.getLocalName() + "\"");
    }

    private RuntimeException missingContent(String elementName) {
        return new IllegalArgumentException("Missing required data for element \"" + elementName + "\"");
    }

    private void handleAuthenticationService(Element parent) {
        block3: for (Element element : this.childrenOf(parent)) {
            switch (this.lookup(element)) {
                case USE_JSF_ACTOR: {
                    this.useJsfActorId = Boolean.valueOf(element.getTextContent());
                    continue block3;
                }
            }
            throw this.unexpectedElement(element);
        }
    }

    private void handleProcessFileMatcher(Element parent) {
        String patternText = null;
        String contentType = null;
        String fileName = null;
        block5: for (Element element : this.childrenOf(parent)) {
            switch (this.lookup(element)) {
                case PATTERN: {
                    patternText = element.getTextContent().trim();
                    continue block5;
                }
                case CONTENT_TYPE: {
                    contentType = element.getTextContent().trim();
                    continue block5;
                }
                case FILE_NAME: {
                    fileName = element.getTextContent().trim();
                    continue block5;
                }
            }
            throw this.unexpectedElement(element);
        }
        if (patternText == null || patternText.length() == 0) {
            throw this.missingContent("pattern");
        }
        if (contentType == null || contentType.length() == 0) {
            throw this.missingContent("content-type");
        }
        if (fileName == null || fileName.length() == 0) {
            throw this.missingContent("file-name");
        }
        this.matchers.add(new Configuration.FileMatcher(Pattern.compile(patternText), contentType, fileName));
    }

    private void handleConfiguration(URL resource) {
        InputStream inputStream;
        try {
            inputStream = resource.openStream();
        }
        catch (IOException e) {
            FacesException ex = new FacesException("Failed to parse jbpm4jsf configuration file: " + e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            Element docElement = document.getDocumentElement();
            switch (this.lookup(docElement)) {
                case JBPM4JSF_CONFIG: {
                    break;
                }
                default: {
                    throw this.unexpectedElement(docElement);
                }
            }
            block18: for (Element element : this.childrenOf(docElement)) {
                switch (this.lookup(element)) {
                    case AUTHENTICATION_SERVICE: {
                        this.handleAuthenticationService(element);
                        continue block18;
                    }
                    case PROCESS_FILE_MATCHER: {
                        this.handleProcessFileMatcher(element);
                        continue block18;
                    }
                }
                throw this.unexpectedElement(element);
            }
        }
        catch (Exception e) {
            FacesException ex = new FacesException("Failed to parse jbpm4jsf configuration file: " + e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close URL input stream: " + e.getMessage());
            }
        }
    }

    private void searchJars() {
        Enumeration<URL> resources;
        String path = "META-INF/jbpm4jsf-config.xml";
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ConfigurationLocator.class.getClassLoader();
        }
        try {
            resources = loader.getResources("META-INF/jbpm4jsf-config.xml");
        }
        catch (IOException e) {
            FacesException ex = new FacesException("Failed to read configuration resource: " + e.getMessage(), e.getCause());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            this.handleConfiguration(resource);
        }
    }

    private void searchWar() {
        String path = "/WEB-INF/jbpm4jsf-config.xml";
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        ServletContext servletContext = (ServletContext)externalContext.getContext();
        try {
            URL resource = servletContext.getResource("/WEB-INF/jbpm4jsf-config.xml");
            this.handleConfiguration(resource);
        }
        catch (MalformedURLException e) {
            FacesException ex = new FacesException("Failed to read configuration resource: " + e.getMessage(), e.getCause());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    static {
        HashMap<String, Elem> map = new HashMap<String, Elem>();
        for (Elem e : Elem.values()) {
            map.put(e.getName(), e);
        }
        elements = Collections.unmodifiableMap(map);
        log = Logger.getLogger("org.jbpm.jsf.core.config.ConfigLocator");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementIterator
    implements Iterator<Element> {
        private Element next = null;
        private Node position;

        public ElementIterator(Element element) {
            this.position = element.getFirstChild();
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.spinToNext();
            }
            return this.next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void spinToNext() {
            if (this.next == null) {
                while (this.position != null) {
                    try {
                        if (!(this.position instanceof Element)) continue;
                        this.next = (Element)this.position;
                        return;
                    }
                    finally {
                        this.position = this.position.getNextSibling();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Element next() {
            if (this.next == null) {
                throw new NoSuchElementException("next() past end");
            }
            try {
                Element element = this.next;
                return element;
            }
            finally {
                this.next = null;
                this.spinToNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not allowed");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementIterable
    implements Iterable<Element> {
        private final Element element;

        ElementIterable(Element element) {
            this.element = element;
        }

        @Override
        public Iterator<Element> iterator() {
            return new ElementIterator(this.element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Elem {
        JBPM4JSF_CONFIG("jbpm4jsf-config"),
        AUTHENTICATION_SERVICE("authentication-service"),
        USE_JSF_ACTOR("use-jsf-actor"),
        PROCESS_FILE_MATCHER("process-file-matcher"),
        PATTERN("pattern"),
        FILE_NAME("file-name"),
        CONTENT_TYPE("content-type");

        private final String elemName;

        private Elem(String elemName) {
            this.elemName = elemName;
        }

        String getName() {
            return this.elemName;
        }
    }
}

