/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.identity.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.identity.Group;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class LoadGroupActionListener
implements JbpmActionListener {
    private final ValueExpression idExpression;
    private final ValueExpression targetExpression;

    public LoadGroupActionListener(ValueExpression idExpression, ValueExpression targetExpression) {
        this.idExpression = idExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "loadGroup";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object idValue = this.idExpression.getValue(elContext);
            IdentitySession identitySession = new IdentitySession(context.getJbpmContext().getSession());
            if (idValue == null) {
                context.setError("Error loading group", "The ID value is null");
                return;
            }
            long id = idValue instanceof Long ? ((Long)idValue).longValue() : Long.valueOf(idValue.toString()).longValue();
            Group group = identitySession.loadGroup(id);
            if (group == null) {
                context.setError("Error loading group", "No group was found with an ID of " + id);
                return;
            }
            this.targetExpression.setValue(elContext, (Object)group);
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error loading group", ex);
            return;
        }
    }
}

