/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.identity.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.identity.Entity;
import org.jbpm.identity.User;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class CreateUserActionListener
implements JbpmActionListener {
    private final ValueExpression userNameExpression;
    private final ValueExpression passwordExpression;
    private final ValueExpression passwordConfirmExpression;
    private final ValueExpression emailExpression;
    private final ValueExpression targetExpression;

    public CreateUserActionListener(ValueExpression userNameExpression, ValueExpression passwordExpression, ValueExpression passwordConfirmExpression, ValueExpression emailExpression, ValueExpression targetExpression) {
        this.userNameExpression = userNameExpression;
        this.passwordExpression = passwordExpression;
        this.passwordConfirmExpression = passwordConfirmExpression;
        this.emailExpression = emailExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "createUser";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            IdentitySession identitySession = new IdentitySession(context.getJbpmContext().getSession());
            if (this.userNameExpression == null) {
                context.setError("Error creating user", "The user name expression is missing");
                return;
            }
            Object userNameValue = this.userNameExpression.getValue(elContext);
            if (userNameValue == null) {
                context.setError("Error creating user", "The user name value is null");
                return;
            }
            User user = new User(userNameValue.toString());
            if (this.passwordExpression != null) {
                Object passwordConfirmValue;
                Object passwordValue = this.passwordExpression.getValue(elContext);
                if (passwordValue == null) {
                    context.setError("Error creating user", "The password value is null");
                    return;
                }
                if (this.passwordConfirmExpression != null && !passwordValue.equals(passwordConfirmValue = this.passwordConfirmExpression.getValue(elContext))) {
                    context.setError("Error creating user", "The password confirmation value does not match the password value");
                    return;
                }
                user.setPassword(passwordValue.toString());
            }
            if (this.emailExpression != null) {
                Object emailValue = this.emailExpression.getValue(elContext);
                if (emailValue == null) {
                    context.setError("Error creating user", "The email value is null");
                    return;
                }
                user.setEmail(emailValue.toString());
            }
            identitySession.saveEntity((Entity)user);
            if (this.targetExpression != null) {
                this.targetExpression.setValue(elContext, (Object)user);
            }
            context.selectOutcome("success");
            context.addSuccessMessage("User created successfully");
        }
        catch (Exception ex) {
            context.setError("Error loading user", ex);
            return;
        }
    }
}

