/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.impl;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdatesHashMap
extends AbstractMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    final Map<String, Object> backingMap;
    final Set<String> updates;
    final Set<String> deletes;

    public UpdatesHashMap() {
        this.backingMap = new HashMap<String, Object>();
        this.updates = new HashSet<String>();
        this.deletes = new HashSet<String>();
    }

    public UpdatesHashMap(Map<String, Object> backingMap) {
        this.backingMap = backingMap == null ? new HashMap<String, Object>() : new HashMap<String, Object>(backingMap);
        this.updates = new HashSet<String>();
        this.deletes = new HashSet<String>();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.backingMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.deletes.remove(key);
        Object old = this.backingMap.put(key, value);
        if (old == value) {
            return old;
        }
        if (old == null != (value == null)) {
            this.updates.add(key);
            return old;
        }
        if (value.equals(old)) {
            return old;
        }
        this.updates.add(key);
        return old;
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof String && this.backingMap.containsKey(key)) {
            this.deletes.add((String)key);
            this.updates.remove(key);
            return this.backingMap.remove(key);
        }
        return null;
    }

    @Override
    public void clear() {
        this.updates.clear();
        this.deletes.clear();
        this.deletes.addAll(this.backingMap.keySet());
        this.backingMap.clear();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new EntrySet(this);
    }

    public Set<String> updatesSet() {
        return Collections.unmodifiableSet(this.updates);
    }

    public Set<String> deletesSet() {
        return Collections.unmodifiableSet(this.deletes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EntrySetIterator
    implements Iterator<Map.Entry<String, Object>> {
        private final Iterator<Map.Entry<String, Object>> iterator;
        private final UpdatesHashMap updatesHashMap;
        private Map.Entry<String, Object> current;

        public EntrySetIterator(UpdatesHashMap updatesHashMap) {
            this.iterator = updatesHashMap.backingMap.entrySet().iterator();
            this.updatesHashMap = updatesHashMap;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            String key = this.current.getKey();
            this.current = null;
            this.updatesHashMap.deletes.add(key);
            this.updatesHashMap.updates.remove(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EntrySet
    extends AbstractSet<Map.Entry<String, Object>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final UpdatesHashMap updatesHashMap;

        public EntrySet(UpdatesHashMap updatesHashMap) {
            this.updatesHashMap = updatesHashMap;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntrySetIterator(this.updatesHashMap);
        }

        @Override
        public int size() {
            return this.updatesHashMap.backingMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.updatesHashMap.backingMap.isEmpty();
        }
    }
}

