/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.identity.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.identity.Group;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class AddMembershipActionListener
implements JbpmActionListener {
    private final ValueExpression userExpression;
    private final ValueExpression groupExpression;
    private final ValueExpression roleExpression;
    private final ValueExpression targetExpression;

    public AddMembershipActionListener(ValueExpression userExpression, ValueExpression groupExpression, ValueExpression roleExpression, ValueExpression targetExpression) {
        this.userExpression = userExpression;
        this.groupExpression = groupExpression;
        this.roleExpression = roleExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "addMembership";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            String roleValueString;
            Object roleValue;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            if (this.userExpression == null) {
                context.setError("Error adding membership", "User expression is required");
                return;
            }
            Object userValue = this.userExpression.getValue(elContext);
            if (userValue == null) {
                context.setError("Error adding membership", "User value is null");
                return;
            }
            User user = (User)userValue;
            if (this.groupExpression == null) {
                context.setError("Error adding membership", "Group expression is required");
                return;
            }
            Object groupValue = this.groupExpression.getValue(elContext);
            if (groupValue == null) {
                context.setError("Error adding membership", "Group value is null");
                return;
            }
            Group group = (Group)groupValue;
            Membership membership = Membership.create((User)user, (Group)group);
            if (this.roleExpression != null && (roleValue = this.roleExpression.getValue(elContext)) != null && (roleValueString = roleValue.toString()).length() > 0) {
                membership.setRole(roleValueString);
            }
            if (this.targetExpression != null) {
                this.targetExpression.setValue(elContext, (Object)membership);
            }
            context.selectOutcome("success");
            context.addSuccessMessage("Successfully added membership");
        }
        catch (Exception ex) {
            context.setError("Error adding membership", ex);
            return;
        }
    }
}

