/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class ResumeActionListener
implements JbpmActionListener {
    private final ValueExpression valueExpression;

    public ResumeActionListener(ValueExpression valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String getName() {
        return "resume";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object value = this.valueExpression.getValue(elContext);
            if (value == null) {
                context.setError("Resume failed", "The value is null");
                return;
            }
            if (value instanceof TaskInstance) {
                ((TaskInstance)value).resume();
                context.addSuccessMessage("Task instance resumed");
            } else if (value instanceof Token) {
                ((Token)value).resume();
                context.addSuccessMessage("Token resumed");
            } else if (value instanceof ProcessInstance) {
                ((ProcessInstance)value).resume();
                context.addSuccessMessage("Process instance resumed");
            } else {
                context.setError("Resume failed", "The value type is not recognized");
                return;
            }
            context.getJbpmContext().getSession().flush();
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Resume failed", ex);
            return;
        }
    }
}

