/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class GetTaskFormInfoActionListener
implements JbpmActionListener {
    private final ValueExpression processExpression;
    private final ValueExpression targetExpression;

    public GetTaskFormInfoActionListener(ValueExpression processExpression, ValueExpression targetExpression) {
        this.processExpression = processExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "getTaskFormInfo";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            ProcessDefinition processDefinition;
            FileDefinition fileDefinition;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object processValue = this.processExpression.getValue(elContext);
            if (processValue == null) {
                context.setError("Error reading form information", "The process value is null");
                return;
            }
            if (!(processValue instanceof ProcessDefinition)) {
                context.setError("Error reading form information", "The process value is not of type ProcessDefinition");
            }
            if (!(fileDefinition = (processDefinition = (ProcessDefinition)processValue).getFileDefinition()).hasFile("forms.xml")) {
                this.targetExpression.setValue(elContext, Collections.emptyMap());
                context.selectOutcome("success");
                return;
            }
            InputStream inputStream = fileDefinition.getInputStream("forms.xml");
            if (inputStream == null) {
                this.targetExpression.setValue(elContext, Collections.emptyMap());
                context.selectOutcome("success");
                return;
            }
            HashMap<String, String> targetMap = new HashMap<String, String>();
            Document document = XmlUtil.parseXmlInputStream((InputStream)inputStream);
            Element documentElement = document.getDocumentElement();
            NodeList nodeList = documentElement.getElementsByTagName("form");
            int length = nodeList.getLength();
            int i = 0;
            while (i < length) {
                Element element = (Element)nodeList.item(i);
                String itemTaskName = element.getAttribute("task");
                String itemFormName = element.getAttribute("form");
                if (itemTaskName != null && itemFormName != null) {
                    targetMap.put(itemTaskName, itemFormName);
                }
                ++i;
            }
            this.targetExpression.setValue(elContext, Collections.unmodifiableMap(targetMap));
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error reading form information", ex);
            return;
        }
    }
}

