/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class StartProcessActionListener
implements JbpmActionListener {
    private final ValueExpression processExpression;
    private final ValueExpression instanceExpression;

    public StartProcessActionListener(ValueExpression processExpression, ValueExpression instanceExpression) {
        this.processExpression = processExpression;
        this.instanceExpression = instanceExpression;
    }

    public String getName() {
        return "startProcess";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object processValue = this.processExpression.getValue(elContext);
            if (processValue == null) {
                context.setError("Error starting process", "The process value is null");
                return;
            }
            if (!(processValue instanceof ProcessDefinition)) {
                context.setError("Error starting process", "Attempted to start something other than a process");
                return;
            }
            ProcessDefinition definition = (ProcessDefinition)processValue;
            ProcessInstance instance = definition.createProcessInstance();
            context.addSuccessMessage("Started process");
            context.selectOutcome("started");
            if (instance.hasEnded()) {
                context.selectOutcome("finished");
                context.addSuccessMessage("Process completed");
            }
            if (this.instanceExpression != null) {
                try {
                    this.instanceExpression.setValue(elContext, (Object)instance);
                }
                catch (ELException ex) {
                    context.setError("Error setting value of " + this.instanceExpression.getExpressionString(), ex);
                    return;
                }
            }
            context.getJbpmContext().save(instance);
        }
        catch (Exception ex) {
            context.setError("Error starting process", ex);
            return;
        }
    }
}

