/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.phase;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.JbpmConfiguration;
import org.jbpm.jsf.core.config.Configuration;
import org.jbpm.jsf.core.config.ConfigurationLocator;

public final class ProcessFilePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger("org.jbpm.jsf.core.phase.ProcessFilePhaseListener");
    private Configuration configuration = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void beforePhase(PhaseEvent event) {
        ProcessFilePhaseListener.log.fine("Entering phase listener");
        facesContext = event.getFacesContext();
        externalContext = facesContext.getExternalContext();
        var4_4 = this;
        synchronized (var4_4) {
            if (this.configuration == null) {
                try {
                    this.configuration = ConfigurationLocator.getInstance();
                }
                catch (Exception ex) {
                    response = (HttpServletResponse)externalContext.getResponse();
                    try {
                        response.sendError(500, "Error loading jbpm configuration: " + ex.getMessage());
                    }
                    catch (IOException e) {
                        ProcessFilePhaseListener.log.log(Level.SEVERE, "Error sending 500 response for bad jbpm configuration load", e);
                    }
                    finally {
                        facesContext.responseComplete();
                    }
                    return;
                }
            }
        }
        servletPath = externalContext.getRequestServletPath();
        pathInfo = externalContext.getRequestPathInfo();
        v0 = servletPath == null ? null : (path = pathInfo == null ? servletPath : servletPath + pathInfo);
        if (path == null) {
            ProcessFilePhaseListener.log.fine("Path is null, skipping");
            return;
        }
        fileMatchers = this.configuration.getMatchers();
        if (ProcessFilePhaseListener.log.isLoggable(Level.FINE)) {
            ProcessFilePhaseListener.log.fine("Checking path against " + fileMatchers.size() + " matchers");
        }
        for (Configuration.FileMatcher fileMatcher : fileMatchers) {
            pattern = fileMatcher.getPattern();
            matcher = pattern.matcher(path);
            if (!matcher.matches()) {
                if (!ProcessFilePhaseListener.log.isLoggable(Level.FINE)) continue;
                ProcessFilePhaseListener.log.fine("Request pattern '" + pattern + "' did NOT match path info '" + path + "'");
                continue;
            }
            if (ProcessFilePhaseListener.log.isLoggable(Level.FINE)) {
                ProcessFilePhaseListener.log.fine("Request pattern '" + pattern + "' MATCHED path info '" + path + "'");
            }
            if (matcher.groupCount() < 1) {
                ProcessFilePhaseListener.log.warning("Configuration pattern '" + pattern + "' does not contain a capturing group for the process ID");
                continue;
            }
            idPart = matcher.group(1);
            id = Long.parseLong(idPart);
            contentType = fileMatcher.getContentType();
            file = fileMatcher.getFile();
            response = (HttpServletResponse)externalContext.getResponse();
            jbpmContext = JbpmConfiguration.getInstance().createJbpmContext();
            try {
                processDefinition = jbpmContext.getGraphSession().getProcessDefinition(id);
                if (processDefinition != null) ** GOTO lbl64
                try {
                    response.sendError(404, "Process definition " + id + " does not exist");
                    facesContext.responseComplete();
                    break;
                }
                catch (IOException e) {
                    ProcessFilePhaseListener.log.log(Level.SEVERE, "Failed to send 404 Not Found to client", e);
lbl64:
                    // 2 sources

                    if (processDefinition.getFileDefinition().hasFile(file)) ** GOTO lbl72
                    try {
                        response.sendError(404, "Process definition " + id + " does not contain file '" + file + "'");
                        facesContext.responseComplete();
                        break;
                    }
                    catch (IOException e) {
                        ProcessFilePhaseListener.log.log(Level.SEVERE, "Failed to send 404 Not Found to client", e);
lbl72:
                        // 2 sources

                        bytes = processDefinition.getFileDefinition().getBytes(file);
                        response.setContentLength(bytes.length);
                        response.setContentType(contentType);
                        try {
                            outputStream = response.getOutputStream();
                            try {
                                outputStream.write(bytes);
                                outputStream.flush();
                            }
                            finally {
                                try {
                                    outputStream.close();
                                }
                                catch (IOException e) {
                                    ProcessFilePhaseListener.log.log(Level.WARNING, "Failed to close output stream", e);
                                }
                            }
                        }
                        catch (IOException e) {
                            ProcessFilePhaseListener.log.log(Level.SEVERE, "Failed to send process file", e);
                        }
                        facesContext.responseComplete();
                        if (ProcessFilePhaseListener.log.isLoggable(Level.FINE)) {
                            ProcessFilePhaseListener.log.fine("Sent process file '" + path + "'");
                        }
                        break;
                    }
                }
            }
            finally {
                jbpmContext.close();
            }
        }
    }

    public void afterPhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

