/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class UpdateVariableActionListener
implements JbpmActionListener {
    private final ValueExpression nameExpression;
    private final ValueExpression valueExpression;
    private final ValueExpression oldValueTargetExpression;
    private final ValueExpression entityExpression;

    public UpdateVariableActionListener(ValueExpression nameExpression, ValueExpression valueExpression, ValueExpression oldValueTargetExpression, ValueExpression entityExpression) {
        this.nameExpression = nameExpression;
        this.valueExpression = valueExpression;
        this.oldValueTargetExpression = oldValueTargetExpression;
        this.entityExpression = entityExpression;
    }

    public String getName() {
        return "updateVariable";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            Object oldValue;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object nameValue = this.nameExpression.getValue(elContext);
            if (nameValue == null) {
                context.setError("Error updating variable", "The value of the 'name' attribute is null");
                return;
            }
            String name = nameValue.toString();
            Object value = this.valueExpression.getValue(elContext);
            Object entity = this.entityExpression.getValue(elContext);
            if (entity instanceof TaskInstance) {
                TaskInstance task = (TaskInstance)entity;
                oldValue = task.getVariable(name);
                task.setVariable(name, value);
            } else if (entity instanceof Token) {
                Token token = (Token)entity;
                ContextInstance contextInstance = token.getProcessInstance().getContextInstance();
                oldValue = contextInstance.getVariable(name, token);
                contextInstance.setVariable(name, value, token);
            } else if (entity instanceof ProcessInstance) {
                ProcessInstance processInstance = (ProcessInstance)entity;
                ContextInstance contextInstance = processInstance.getContextInstance();
                oldValue = contextInstance.getVariable(name);
                contextInstance.setVariable(name, value);
            } else {
                context.setError("Error updating variable", "The value given for the 'entity' attribute is not a task, token, or process instance");
                return;
            }
            if (this.oldValueTargetExpression != null) {
                this.oldValueTargetExpression.setValue(elContext, oldValue);
            }
            context.addSuccessMessage("Variable updated");
            context.getJbpmContext().getSession().flush();
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error updating variable", ex);
            return;
        }
    }
}

