/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm;

import java.util.Map;

/** central starting point for all process engine API
 * interactions. 
 * 
 * @author Tom Baeyens
 */
public interface ProcessEngine {

  /** the {@link ProcessService process service} that provides access
   * to the process repository. */ 
  ProcessService getProcessService();

  /** the {@link ProcessService process service} and supply some 
   * transactional resources.  The given transactional resources will only 
   * be associated to the returned process service.  */ 
  ProcessService getProcessService(Map<String, Object> txResources);

  /** the {@link ExecutionService execution service} that provides access
   * to the runtime executions repository. */ 
  ExecutionService getExecutionService();

  /** the {@link ExecutionService execution service} and supply some 
   * transactional resources.  The given transactional resources will only 
   * be associated to the returned execution service.  */ 
  ExecutionService getExecutionService(Map<String, Object> txResources);

  /** the {@link TaskService task service} that exposes the 
   * runtime human task lists. */ 
  TaskService getTaskService();

  /** the {@link TaskService task service} and supply some 
   * transactional resources.  The given transactional resources will only 
   * be associated to the returned task service.  */ 
  TaskService getTaskService(Map<String, Object> txResources);

  /** the {@link ManagementService management service} that exposes the 
   * management operations to operators that have to keep the jBPM system 
   * up and running. */ 
  ManagementService getManagementService();

  /** the {@link ManagementService management service} and supply some 
   * transactional resources.  The given transactional resources will only 
   * be associated to the returned management service. */ 
  ManagementService getManagementService(Map<String, Object> txResources);

  /** retrieve and object defined in the process engine by type */
  <T> T get(Class<T> type);

  /** retrieve and object defined in the process engine by name */
  Object get(String name);
}
