/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm;

import java.util.List;


/** a process definition repository.
 * 
 * @author Tom Baeyens
 */
public interface ProcessService {
  
  /** start a deployment */
  Deployment createDeployment();

  /** all deployed process definition keys. */
  List<String> findProcessDefinitionKeys();

  /** all versions of the given process. 
   * @return the process definitions in descending version order.  So you get the 
   * highest version number as the first. */
  List<ProcessDefinition> findProcessDefinitionsByKey(String processDefinitionKey);

  /** latest version of the processDefinition with the given key. */
  ProcessDefinition findLatestProcessDefinitionByKey(String processDefinitionKey);

  /** specific version of a named processDefinition. */
  ProcessDefinition findProcessDefinitionById(String processDefinitionId);
  
  /** search for process definitions */
  ProcessDefinitionQuery createProcessDefinitionQuery();

  /** deletes process definition if there are no existing executions. 
   * @throws JbpmException if there are existing executions. */
  void deleteProcessDefinition(String processDefinitionId);

  /** deletes process definition and the existing executions. */
  void deleteProcessDefinitionAndInstances(String processDefinitionId);

  
  /** TODO REMOVE: deploy a new process definition into the process repository. */
  List<ProcessDefinition> deploy(Deployment deployment);
}
