/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.activity;

import java.io.Serializable;

/** piece of Java code that is to be included in a process as the runtime 
 * node behaviour or as a hidden listener to process events.
 * 
 * @author Tom Baeyens
 */
public interface Activity extends Serializable {
  
  /** piece of Java code that is to be included in a process as node behaviour 
   * or as a hidden listener to process events.
   * 
   * <p>Activities can be used to implement the behaviour of nodes, in 
   * which case this behaviour is associated to a graphical node in the diagram,
   * or they can be added as events, in that case, they are being hidden from 
   * the diagram.
   * </p>
   * 
   * <p>If an activity is the node behaviour, then it can control the propagation 
   * of execution.  Node behaviours can be external activities.  That means their 
   * runtime behaviour is a wait state.  In that case, {@link ExternalActivity} 
   * should be implemented to also handle the external triggers. 
   * </p>
   */
  void execute(ActivityExecution execution) throws Exception;
}
