/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.model;

import java.util.List;
import java.util.Map;



/** node container base class for {@link OpenProcessDefinition} and {@link Node}.
 * 
 * @author Tom Baeyens
 */
public interface CompositeElement extends ObservableElement {

  /** indicates if this processDefinition has nodes. */
  boolean hasNodes();

  /** the list of composite nodes.
   * Beware: the actual member is returned.  No copy is made. */
  List<Node> getNodes();

  /** indicates if a node with the given name exists in this processDefinition. */
  boolean hasNode(String nodeName);

  /** the first composite node with the given name or null of no
   * such node exists. */
  Node getNode(String nodeName);

  /** searches for the given node in this node, including this node and 
   * all child nodes recursively.  The search is done depth-first. 
   * A null value for nodeName matches a node without a name. */
  Node findNode(String nodeName);

  /** the composite nodes, keyed by node name.  If a node with 
   * the same name occurs mutltiple times, the first in the list
   * is included in the map. Nodes with a null value for their name 
   * are not included in the map. 
   * Beware: the actual member is returned.  No copy is made. In fact, the 
   * returned map is maintained as a cache.  So updates to the map will 
   * influence subsequent retrievals of nodes by name.*/
  Map<String, Node> getNodesMap();
}
