/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.processlog;

import org.jbpm.session.LogSession;


/** filtering log session.
 * 
 * @author Tom Baeyens
 */
public class LogSessionFilter implements LogSession {
  
  protected LogSession delegate;
  protected String type;

  public void add(ProcessLog processLog) {
    if (passes(processLog)){
      delegate.add(processLog);
    }
  }

  /** can be overwritten in case filtering needs to be more 
   * sophisticated then just type matching. */
  protected boolean passes(ProcessLog processLog) {
    return ((type==null) || (type.equals(processLog.getType())));
  }

  public void setDelegate(LogSession delegate) {
    this.delegate = delegate;
  }

  public void setType(String type) {
    this.type = type;
  }
}
