/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.task;

import java.io.Serializable;
import java.util.Date;

/** runtime task.
 * 
 * @author Tom Baeyens
 */
public interface Task extends Serializable {
  
  /** can do anything with the task */
  String ROLETYPE_OWNER = "owner"; 
  
  /** alternative owner, but as long as this person is not the owner. 
   * This person is allowed to make comments, but nothing else. */
  String ROLETYPE_CANDIDATE = "candidate"; 
  
  /** person that will be using the result of this task.  This person is 
   * allowed to make comments, but nothing else. */
  String ROLETYPE_CLIENT = "client";
  
  /** person that is allowed to watch-but-not-touch this task */
  String ROLETYPE_VIEWER = "viewer";
  
  /** a person that was assigned to a task, but got replaced because of 
   * absence or another reason. This way, a trace can be left in case 
   * This person returns and wants to take back his tasks that got 
   * reassigned. */
  String ROLETYPE_REPLACED_ASSIGNEE = "replaced-assignee";

  String getId();

  String getName();
  void setName(String name);

  String getDescription();
  void setDescription(String description);

  String getAssignee();
  void setAssignee(String assignee);

  Date getCreate();

  Date getDueDate();
  void setDueDate(Date dueDate);

  int getPriority();
  void setPriority(int priority);

}