/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.api;

import java.util.List;

import org.jbpm.api.task.Task;


/**
 * @author Tom Baeyens
 * @author Heiko Braun <heiko.braun@jboss.com>
 */
public interface TaskQuery {
  
  public static final String PROPERTY_NAME = "name";
  public static final String PROPERTY_ASSIGNEE = "assignee";
  public static final String PROPERTY_CREATEDATE = "create";
  public static final String PROPERTY_DUEDATE = "dueDate";
  public static final String PROPERTY_PRIORITY = "priority";
  public static final String PROPERTY_PROGRESS = "progress";

  /** only find tasks for which the given user is the assignee */
  TaskQuery assignee(String userId);
  
  /** query for tasks that are unassigned.
   * These tasks can still potentially have candidates. */
  TaskQuery unassigned();

  /** only query for tasks that are takable by the given user. */
  TaskQuery takableBy(String userId);

  TaskQuery page(int firstResult, int maxResults);
  TaskQuery orderAsc(String property);
  TaskQuery orderDesc(String property);
  
  List<Task> list();
  Task uniqueResult();
}
