/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.api.session;

import java.util.List;

import org.jbpm.api.Execution;
import org.jbpm.api.client.ClientExecution;
import org.jbpm.api.client.ClientProcessDefinition;
import org.jbpm.api.job.Job;
import org.jbpm.api.job.Message;
import org.jbpm.api.job.Timer;

/**
 * @author Tom Baeyens
 */
public interface PvmDbSession extends DbSession {
  
  // process definition queries ///////////////////////////////////////////////

  /** all deployed process names. */
  List<String> findProcessDefinitionKeys();

  /** latest version of the processDefinition for the given key. */
  ClientProcessDefinition findLatestProcessDefinitionByKey(String processDefinitionKey);

  /** all versions of the processDefinition for the given key. */
  List<ClientProcessDefinition> findProcessDefinitionsByKey(String processDefinitionKey);

  /** the process definition uniquely identified by the given 
   * processDefinition id. */
  ClientProcessDefinition findProcessDefinitionById(String processDefinitionId);

  /** the first key for an existing process definition with the given processDefinitionName
  * @returns null in case no such processDefinitionName exists */
  String findProcessDefinitionKeyByName(String processDefinitionName);

  /** the first name for an existing process definition with the given processDefinitionKey 
   * @returns null in case no such processDefinitionKey exists */
  String findProcessDefinitionNameByKey(String processDefinitionKey);

  /** delete process definition */
  void deleteProcessDefinition(String processDefinitionId, boolean deleteProcessInstances, boolean deleteHistory);

  // process execution queries ////////////////////////////////////////////////

  /** the execution uniquely identified by the given executionKey. */ 
  ClientExecution findExecutionById(String executionId);

  /** the process instance uniquely identified by the given executionKey. */ 
  ClientExecution findProcessInstanceById(String processInstanceId);

  /** the execution uniquely identified by the given processDefinition name 
   * and the execution key. */
  ClientExecution findExecutionByKey(String processDefinitionName, String executionKey);
  
  /* find ids for all process instances for a given process definition. */
  List<String> findProcessInstanceIds(String processDefinitionId);

  /** delete the process instance including the history. */
  void deleteProcessInstance(String processInstanceId);

  /** delete the process instance and optionally deletes the history. */
  void deleteProcessInstance(String processInstanceId, boolean deleteHistory);

  // job queries //////////////////////////////////////////////////////////////

  /** timers */
  List<Timer> findTimers(int firstResult, int maxResults);
  
  /** timers */
  List<Message> findMessages(int firstResult, int maxResults);
  
  /** the jobs for which all the retries have failed and which will not be 
   * picked up any more by the jobImpl executor */
  public List<Job> findJobsWithException(int firstResult, int maxResults);

}
