/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.api;

import java.util.List;

/**
 * @author Tom Baeyens
 */
public interface ProcessDefinitionQuery {

  String PROPERTY_ID = "idProperty.stringValue";
  String PROPERTY_KEY = "keyProperty.stringValue";
  String PROPERTY_NAME = "idProperty.objectName";
  String PROPERTY_VERSION = "versionProperty.longValue";
  String PROPERTY_DEPLOYMENT_TIMESTAMP = "deployment.timestamp";

  ProcessDefinitionQuery processDefinitionId(String processDefinitionId);
  ProcessDefinitionQuery processDefinitionKey(String key);
  ProcessDefinitionQuery processDefinitionNameLike(String name);
  ProcessDefinitionQuery processDefinitionName(String name);
  ProcessDefinitionQuery deploymentDbid(long deploymentDbid);
  ProcessDefinitionQuery suspended();

  ProcessDefinitionQuery orderAsc(String property);
  ProcessDefinitionQuery orderDesc(String property);

  ProcessDefinitionQuery page(int firstResult, int maxResults);
  
  List<ProcessDefinition> list();
  ProcessDefinition uniqueResult();
}
