/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.api.activity;

import java.io.Serializable;

/** piece of Java code that is to be included in a process as the runtime 
 * activity behaviour.
 * 
 * @author Tom Baeyens
 */
public interface ActivityBehaviour extends Serializable {
  
  /** piece of Java code that is to be included in a process as activity behaviour 
   * or as a hidden listener to process events.
   * 
   * <p>ActivityBehaviour's can be used to implement the behaviour of activities, in 
   * which case this behaviour is associated to a graphical activity in the diagram.
   * </p>
   * 
   * <p>An ActivityBehaviour can control the propagation 
   * of execution.  ActivityBehaviour's can become external activities when they 
   * invoke {@link ActivityExecution#waitForSignal()}.  That means the 
   * activity will become a wait state.  In that case, {@link ExternalActivityBehaviour} 
   * should be implemented to also handle the external triggers. 
   * </p>
   */
  void execute(ActivityExecution execution) throws Exception;
}
