/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.api.task;

import java.io.Serializable;

import org.jbpm.api.JbpmException;


/**
 * references an identity. usally a user or group.
 *
 * @see org.jbpm.api.task.UserRef
 * @see org.jbpm.api.task.GroupRef
 * @see org.jbpm.api.task.Participation
 *
 * @author Tom Baeyens
 * @author Heiko Braun
 */
public abstract class IdentityRef implements Serializable {
  
  private static final long serialVersionUID = 1L;

  protected String id;

  public IdentityRef(String id) {
    if (id==null) {
      throw new JbpmException("id is null");
    }
    this.id = id;
  }

  public String getId() {
    return id;
  }

  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((id == null) ? 0 : id.hashCode());
    return result;
  }

  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    IdentityRef other = (IdentityRef) obj;
    if (!id.equals(other.id))
      return false;
    return true;
  }
}
