/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.api.env;

import java.io.Serializable;
import java.util.Stack;
import org.jbpm.api.JbpmException;
import org.jbpm.api.env.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Environment
implements Serializable {
    static ThreadLocal<Environment> currentEnvironment = new ThreadLocal();
    static ThreadLocal<Stack<Environment>> currentEnvironmentStack = new ThreadLocal();

    public abstract Object get(String var1);

    public abstract Object get(String var1, String[] var2);

    public abstract <T> T get(Class<T> var1);

    public abstract <T> T get(Class<T> var1, String[] var2);

    public abstract String getUserId();

    public abstract void setUserId(String var1);

    public abstract void close();

    public abstract Context getContext(String var1);

    public abstract void setContext(Context var1);

    public abstract Context removeContext(Context var1);

    public abstract Context removeContext(String var1);

    public abstract ClassLoader getClassLoader();

    public abstract void setClassLoader(ClassLoader var1);

    public static Environment getCurrent() {
        return currentEnvironment.get();
    }

    public static <T> T getFromCurrent(Class<T> type) {
        return Environment.getFromCurrent(type, true);
    }

    public static <T> T getFromCurrent(Class<T> type, boolean required) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            if (required) {
                throw new JbpmException("no environment to get " + type.getName());
            }
            return null;
        }
        T object = environment.get(type);
        if (object == null) {
            if (required) {
                throw new JbpmException("no " + type.getName() + " in current environment");
            }
            return null;
        }
        return object;
    }

    public static Object getFromCurrent(String name) {
        return Environment.getFromCurrent(name, true);
    }

    public static Object getFromCurrent(String name, boolean required) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            if (required) {
                throw new JbpmException("no environment to get '" + name + "'");
            }
            return null;
        }
        Object object = environment.get(name);
        if (object == null) {
            if (required) {
                throw new JbpmException("no '" + name + "' in current environment");
            }
            return null;
        }
        return object;
    }

    static Stack<Environment> getStack() {
        Stack<Environment> stack = currentEnvironmentStack.get();
        if (stack == null) {
            stack = new Stack();
            currentEnvironmentStack.set(stack);
        }
        return stack;
    }

    public static synchronized Environment popEnvironment() {
        Environment popped = currentEnvironment.get();
        currentEnvironment.set(null);
        Stack<Environment> stack = currentEnvironmentStack.get();
        if (stack != null && !stack.isEmpty()) {
            currentEnvironment.set(stack.pop());
        }
        return popped;
    }

    public static synchronized void pushEnvironment(Environment environment) {
        Environment current = currentEnvironment.get();
        if (current != null) {
            Environment.getStack().push(current);
        }
        currentEnvironment.set(environment);
    }
}

