/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.bpmn.flownodes;

import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

/**
 * @author Tom Baeyens
 * @author Ronald van Kuijk (kukeltje)
 * 
 */
public class ExclusiveGatewayBinding extends AbstractGatewayBinding {

  public ExclusiveGatewayBinding() {
    super("exclusiveGateway");
  }

  public Object parse(Element element, Parse parse, Parser parser) {

    super.parse(element, parse);

    String default_ = null;
    if (element.hasAttribute("default")) {
      default_ = element.getAttribute("default");
    }

    // Check if all outgoing sequence flow have a condition (default excluded)
    boolean defaultExists = false;
    for (Element outSeqFlow : outSequenceFlows) {
      
      String sourceRef = outSeqFlow.getAttribute("sourceRef");
      Element conditionalExpression = XmlUtil.element(outSeqFlow, "conditionExpression");
      
      if (id.equals(sourceRef)) {
        
        if (outSeqFlow.getAttribute("id").equals(default_)) {
          defaultExists = true;
        } else if (default_ != null && conditionalExpression == null) {  // All but the 'default' sequenceFlow need to have a condition
          parse.addProblem("exclusiveGateway '" + name + "' has default sequenceFlow '" + default_ 
                  + "' but " + outSeqFlow.getAttribute("id")
                  + " does not have a required conditionExpression", element);
          valid = false; // do not break. Parsing may find other issues;
        }
        
      }
      
    }

    if (default_ != null && !defaultExists) {
      parse.addProblem("exclusiveGateway '" + name + "' default sequenceFlow '" + default_ 
              + "' does not exist or is not related to this node", element);
      valid = false;
    }

    if (!valid) {
      return null;
    }

    ExclusiveGatewayActivity exclusiveGatewayActivity = new ExclusiveGatewayActivity();
    exclusiveGatewayActivity.setDefault(default_);
    exclusiveGatewayActivity.setGatewayDirection(gatewayDirection);

    return exclusiveGatewayActivity;
  }
}
