/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.bpmn.flownodes.ActivityResource;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.model.Activity;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.Condition;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BpmnActivity
implements ActivityBehaviour {
    private static final Log log = Log.getLog((String)BpmnActivity.class.getName());
    private static final long serialVersionUID = 1L;
    protected static final boolean FORK_ALLOWED = true;
    protected static final boolean FORK_DISALLOWED = false;
    protected static final boolean CONDITIONS_CHECKED = true;
    protected static final boolean CONDITIONS_IGNORED = false;
    protected List<ActivityResource> activityResources = new ArrayList<ActivityResource>();

    protected void proceed(ExecutionImpl execution, List<Transition> transitions) {
        if (log.isDebugEnabled()) {
            log.debug("Proceeding from execution " + execution.getActivityName());
        }
        ActivityImpl activity = execution.getActivity();
        if (transitions.size() == 0) {
            execution.end();
        } else if (transitions.size() == 1) {
            execution.take(transitions.get(0));
        } else {
            ExecutionImpl concurrentRoot = null;
            if ("active-root".equals(execution.getState())) {
                concurrentRoot = execution;
                execution.setState("inactive-concurrent-root");
                execution.setActivity(null);
            } else if ("active-concurrent".equals(execution.getState())) {
                concurrentRoot = execution.getParent();
            }
            for (Transition transition : transitions) {
                String childExecutionName = transition.getName();
                ExecutionImpl concurrentExecution = concurrentRoot.createExecution(childExecutionName);
                concurrentExecution.setActivity((Activity)activity);
                concurrentExecution.setState("active-concurrent");
                concurrentExecution.take(transition);
                if (!concurrentRoot.isEnded()) continue;
                break;
            }
        }
    }

    protected List<Transition> findTransitions(ExecutionImpl execution, boolean checkConditions) {
        ActivityImpl activity = execution.getActivity();
        ArrayList<Transition> forkingTransitions = new ArrayList<Transition>();
        List outgoingTransitions = activity.getOutgoingTransitions();
        for (Transition transition : outgoingTransitions) {
            Condition condition = transition.getCondition();
            if (condition != null && checkConditions && !condition.evaluate((OpenExecution)execution) || activity.getDefaultOutgoingTransition() == transition) continue;
            forkingTransitions.add(transition);
        }
        if (log.isDebugEnabled()) {
            log.debug(forkingTransitions.size() + " out of " + outgoingTransitions.size() + " selected for " + activity.getName());
        }
        return forkingTransitions;
    }

    public void addActivityResource(ActivityResource activityResource) {
        this.activityResources.add(activityResource);
    }
}

