/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.parser;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.xml.namespace.QName;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.bpmn.common.Resource;
import org.jbpm.bpmn.common.ResourceParameter;
import org.jbpm.bpmn.flownodes.BpmnBinding;
import org.jbpm.bpmn.flownodes.ExclusiveGatewayActivity;
import org.jbpm.bpmn.model.BpmnProcessDefinition;
import org.jbpm.bpmn.parser.BindingsParser;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.Condition;
import org.jbpm.pvm.internal.model.ExpressionCondition;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.ScopeElementImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.model.VariableDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;
import org.jbpm.pvm.internal.util.TagBinding;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.binding.ObjectBinding;
import org.jbpm.pvm.internal.wire.xml.WireParser;
import org.jbpm.pvm.internal.xml.Binding;
import org.jbpm.pvm.internal.xml.Bindings;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnParser
extends Parser {
    private static final Log log = Log.getLog((String)BpmnParser.class.getName());
    static ObjectBinding objectBinding = new ObjectBinding();
    public static final WireParser wireParser = WireParser.getInstance();
    static final String[] DEFAULT_ACTIVITIES_RESOURCES = new String[]{"jbpm.bpmn.flownodes.xml"};
    static final String CATEGORY_ACTIVITY = "activity";
    static BindingsParser bindingsParser = new BindingsParser();

    public BpmnParser() {
        this.initialize();
        this.parseBindings();
        ArrayList<String> schemaResources = new ArrayList<String>();
        schemaResources.add("BPMN20.xsd");
        this.setSchemaResources(schemaResources);
    }

    public Object parseDocumentElement(Element documentElement, Parse parse) {
        ArrayList<ProcessDefinitionImpl> processDefinitions = new ArrayList<ProcessDefinitionImpl>();
        this.parseDefinition(documentElement, parse);
        for (Element processElement : XmlUtil.elements((Element)documentElement, (String)"process")) {
            ProcessDefinitionImpl processDefinition = this.parseProcess(processElement, parse);
            processDefinitions.add(processDefinition);
        }
        return processDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessDefinitionImpl parseProcess(Element processElement, Parse parse) {
        BpmnProcessDefinition processDefinition = new BpmnProcessDefinition();
        parse.contextStackPush((Object)processDefinition);
        try {
            Element descriptionElement;
            String name = XmlUtil.attribute((Element)processElement, (String)"name", (boolean)true, (Parse)parse);
            processDefinition.setName(name);
            String key = XmlUtil.attribute((Element)processElement, (String)"id", (boolean)false, (Parse)parse);
            if (key != null) {
                processDefinition.setKey(key);
            }
            if ((descriptionElement = XmlUtil.element((Element)processElement, (String)"documentation")) != null) {
                String description = XmlUtil.getContentText((Element)descriptionElement);
                processDefinition.setDescription(description);
            }
            this.parseResources((Element)processElement.getParentNode(), parse, processDefinition);
            this.parseInterfaces((Element)processElement.getParentNode(), parse, processDefinition);
            this.parseItemDefinitions((Element)processElement.getParentNode(), parse, processDefinition);
            this.parseMessages((Element)processElement.getParentNode(), parse, processDefinition);
            this.parseDataObjects(processElement, parse, processDefinition);
            this.parseActivities(processElement, parse, (CompositeElementImpl)processDefinition);
            this.parseSequenceFlows(processElement, parse, (CompositeElementImpl)processDefinition);
        }
        finally {
            parse.contextStackPop();
        }
        return processDefinition;
    }

    protected void parseBindings() {
        Bindings bindings = new Bindings();
        this.setBindings(bindings);
        for (String activityResource : DEFAULT_ACTIVITIES_RESOURCES) {
            Enumeration<URL> resourceUrls = this.getResources(activityResource);
            if (resourceUrls.hasMoreElements()) {
                while (resourceUrls.hasMoreElements()) {
                    URL resourceUrl = resourceUrls.nextElement();
                    log.trace("loading bpmn activities from resource: " + resourceUrl);
                    List activityBindings = (List)bindingsParser.createParse().setUrl(resourceUrl).execute().checkErrors("bpmn activities from " + resourceUrl.toString()).getDocumentObject();
                    for (BpmnBinding binding : activityBindings) {
                        binding.setCategory(CATEGORY_ACTIVITY);
                        bindings.addBinding((Binding)binding);
                    }
                }
                continue;
            }
            log.trace("skipping unavailable activities resource: " + activityResource);
        }
    }

    protected Enumeration<URL> getResources(String resourceName) {
        Enumeration<URL> resourceUrls;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            resourceUrls = classLoader.getResources(resourceName);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't get resource urls for " + resourceName, (Throwable)e);
        }
        return resourceUrls;
    }

    private void parseDataObjects(Element element, Parse parse, BpmnProcessDefinition processDefinition) {
        ArrayList<VariableDefinitionImpl> variableDefinitions = new ArrayList<VariableDefinitionImpl>();
        for (Element dataElement : XmlUtil.elements((Element)element, (String)"dataObject")) {
            VariableDefinitionImpl variableDefinition = new VariableDefinitionImpl();
            String name = XmlUtil.attribute((Element)dataElement, (String)"id", (boolean)true, (Parse)parse);
            variableDefinition.setName(name);
            String typeRef = XmlUtil.attribute((Element)dataElement, (String)"itemSubjectRef");
            variableDefinition.setTypeName(processDefinition.getType(typeRef));
            variableDefinitions.add(variableDefinition);
        }
        processDefinition.setVariableDefinition(variableDefinitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseActivities(Element element, Parse parse, CompositeElementImpl compositeElement) {
        List elements = XmlUtil.elements((Element)element);
        for (Element nestedElement : elements) {
            String tagName = XmlUtil.getTagLocalName((Element)nestedElement);
            String name = XmlUtil.attribute((Element)nestedElement, (String)"name", (boolean)false, (Parse)parse);
            String id = XmlUtil.attribute((Element)nestedElement, (String)"id", (boolean)true, (Parse)parse);
            TagBinding activityBinding = (TagBinding)this.getBinding(nestedElement, CATEGORY_ACTIVITY);
            if (activityBinding == null) {
                if ("sequenceFlow".equals(tagName)) continue;
                log.debug("unrecognized activity: " + tagName);
                continue;
            }
            ActivityImpl activity = compositeElement.createActivity();
            parse.contextStackPush((Object)activity);
            try {
                activity.setType(activityBinding.getTagName());
                activity.setName(id);
                activity.setDescription(name);
                log.debug("Parse Activity: " + name);
                ActivityBehaviour activityBehaviour = (ActivityBehaviour)activityBinding.parse(nestedElement, parse, (Parser)this);
                activity.setActivityBehaviour(activityBehaviour);
            }
            finally {
                parse.contextStackPop();
            }
        }
    }

    public void parseSequenceFlows(Element element, Parse parse, CompositeElementImpl compositeElement) {
        List transitionElements = XmlUtil.elements((Element)element, (String)"sequenceFlow");
        for (Element transitionElement : transitionElements) {
            TransitionImpl transition;
            Element conditionElement;
            String targetRef;
            String transitionId;
            String transitionName;
            block9: {
                transitionName = XmlUtil.attribute((Element)transitionElement, (String)"name", (boolean)false, (Parse)parse);
                transitionId = XmlUtil.attribute((Element)transitionElement, (String)"id", (boolean)false, (Parse)parse);
                String sourceRef = XmlUtil.attribute((Element)transitionElement, (String)"sourceRef", (boolean)true, (Parse)parse);
                targetRef = XmlUtil.attribute((Element)transitionElement, (String)"targetRef", (boolean)true, (Parse)parse);
                log.trace(transitionId + ": " + sourceRef + " -> " + targetRef);
                conditionElement = XmlUtil.element((Element)transitionElement, (String)"conditionExpression");
                log.trace("    with " + (conditionElement == null ? "0" : "1") + " conditionExpression");
                transition = compositeElement.findActivity(sourceRef).createOutgoingTransition();
                try {
                    ActivityBehaviour a = compositeElement.findActivity(sourceRef).getActivityBehaviour();
                    if (a instanceof ExclusiveGatewayActivity) {
                        if (transitionId.equals(((ExclusiveGatewayActivity)a).getDefault())) {
                            compositeElement.findActivity(sourceRef).setDefaultOutgoingTransition(transition);
                        }
                    } else {
                        compositeElement.findActivity(sourceRef).setDefaultOutgoingTransition(null);
                    }
                }
                catch (JbpmException je) {
                    if (je.getMessage().contains("no behaviour on")) break block9;
                    throw je;
                }
            }
            if (conditionElement != null) {
                String type = conditionElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                if ("bpmn:tFormalExpression".equals(type) || "tFormalExpression".equals(type)) {
                    String expr = conditionElement.getTextContent();
                    String lang = XmlUtil.attribute((Element)conditionElement, (String)"language");
                    ExpressionCondition expressionCondition = new ExpressionCondition();
                    expressionCondition.setExpression(expr);
                    expressionCondition.setLanguage(lang);
                    transition.setCondition((Condition)expressionCondition);
                } else {
                    parse.addProblem("Type of the conditionExpression on sequenceFlow with id=" + transitionId + " is of onsupported type 'bpmn:tExpression'", transitionElement);
                }
            }
            compositeElement.findActivity(targetRef).addIncomingTransition(transition);
            transition.setName(transitionId);
            transition.setDescription(transitionName);
        }
    }

    public void parseDefinition(Element documentElement, Parse parse) {
        this.parseImports(documentElement, parse);
    }

    public static TaskDefinitionImpl parseTaskDefinition(Element element, Parse parse, ScopeElementImpl scopeElement) {
        TaskDefinitionImpl taskDefinition = new TaskDefinitionImpl();
        String taskName = XmlUtil.attribute((Element)element, (String)"name");
        taskDefinition.setName(taskName);
        BpmnProcessDefinition processDefinition = (BpmnProcessDefinition)((Object)parse.contextStackFind(BpmnProcessDefinition.class));
        if (processDefinition.getTaskDefinition(taskName) != null) {
            parse.addProblem("duplicate task name " + taskName, element);
        } else {
            processDefinition.addTaskDefinitionImpl(taskDefinition);
        }
        return taskDefinition;
    }

    private void parseResources(Element documentElement, Parse parse, BpmnProcessDefinition processDefinition) {
        for (Element resourceElement : XmlUtil.elements((Element)documentElement, (String)"resource")) {
            Resource resource = new Resource();
            resource.setId(XmlUtil.attribute((Element)resourceElement, (String)"id"));
            resource.setName(XmlUtil.attribute((Element)resourceElement, (String)"name"));
            for (Element resourceParameterElement : XmlUtil.elements((Element)documentElement, (String)"resourceParameter")) {
                ResourceParameter resourceParameter = new ResourceParameter();
                resourceParameter.setId(XmlUtil.attribute((Element)resourceParameterElement, (String)"id"));
                resourceParameter.setName(XmlUtil.attribute((Element)resourceParameterElement, (String)"name"));
                resourceParameter.setType(QName.valueOf(XmlUtil.attribute((Element)resourceParameterElement, (String)"name")));
                resource.getParameters().put(XmlUtil.attribute((Element)resourceParameterElement, (String)"name"), resourceParameter);
            }
            processDefinition.getResources().put(resource.getName(), resource);
        }
    }

    private void parseInterfaces(Element documentElement, Parse parse, BpmnProcessDefinition processDefinition) {
        for (Element interfaceElement : XmlUtil.elements((Element)documentElement, (String)"interface")) {
            for (Element operationElement : XmlUtil.elements((Element)interfaceElement, (String)"operation")) {
                processDefinition.getOperations().put(XmlUtil.attribute((Element)operationElement, (String)"id"), operationElement);
            }
            processDefinition.getInterfaces().put(XmlUtil.attribute((Element)interfaceElement, (String)"id"), interfaceElement);
        }
    }

    private void parseMessages(Element documentElement, Parse parse, BpmnProcessDefinition processDefinition) {
        for (Element messageElement : XmlUtil.elements((Element)documentElement, (String)"message")) {
            processDefinition.getMessages().put(XmlUtil.attribute((Element)messageElement, (String)"id"), messageElement);
        }
    }

    private void parseItemDefinitions(Element documentElement, Parse parse, BpmnProcessDefinition processDefinition) {
        for (Element itemDefinitionElement : XmlUtil.elements((Element)documentElement, (String)"itemDefinition")) {
            processDefinition.getItemDefinitions().put(XmlUtil.attribute((Element)itemDefinitionElement, (String)"id"), itemDefinitionElement);
        }
    }

    private void parseImports(Element documentElement, Parse parse) {
    }
}

