/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.forms;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.naming.InitialContext;
import org.jbpm.api.ProcessEngine;
import org.jbpm.integration.spi.mgmt.ServerConfig;
import org.jbpm.integration.spi.mgmt.ServerConfigFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFormDispatcher {
    protected static final String WEB_CONTEXT = "/gwt-console-server/rs";
    protected ProcessEngine processEngine;
    protected ServerConfig serverConfig = null;
    protected static final String FORM_DIRECTIVE_KEY = "form";
    protected static final String OUTCOME_DIRECTIVE_NAME = "outcome";

    public AbstractFormDispatcher() {
        this.initializeProcessEngine();
    }

    protected void initializeProcessEngine() {
        try {
            InitialContext ctx = new InitialContext();
            this.processEngine = (ProcessEngine)ctx.lookup("java:/ProcessEngine");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lookup process engine", e);
        }
    }

    protected ServerConfig getServerConfig() {
        if (null == this.serverConfig) {
            this.serverConfig = ServerConfigFactory.getServerConfig();
        }
        return this.serverConfig;
    }

    protected StringBuilder getBaseUrl() {
        StringBuilder spec = new StringBuilder();
        spec.append("http://");
        spec.append(this.getServerConfig().getWebServiceHost());
        spec.append(":").append(this.getServerConfig().getWebServicePort());
        spec.append(WEB_CONTEXT);
        return spec;
    }

    protected DataHandler processTemplate(final String name, InputStream src, Map<String, Object> renderContext) {
        DataHandler merged = null;
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(src), cfg);
            final ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(bout);
            temp.process(renderContext, (Writer)out);
            ((Writer)out).flush();
            merged = new DataHandler(new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(bout.toByteArray());
                }

                public OutputStream getOutputStream() throws IOException {
                    return bout;
                }

                public String getContentType() {
                    return "application/octet-stream";
                }

                public String getName() {
                    return name + "_DataSource";
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process task template", e);
        }
        return merged;
    }
}

