/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.forms;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataHandler;
import org.jboss.bpm.console.server.plugin.FormAuthorityRef;
import org.jboss.bpm.console.server.plugin.FormDispatcherPlugin;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.RepositoryService;
import org.jbpm.integration.console.forms.AbstractFormDispatcher;
import org.jbpm.integration.console.forms.FormDirective;
import org.jbpm.integration.console.forms.OutcomeDirective;

public class ProcessFormDispatcher
extends AbstractFormDispatcher
implements FormDispatcherPlugin {
    public URL getDispatchUrl(FormAuthorityRef ref) {
        if (!this.processHasForm(ref.getReferenceId())) {
            return null;
        }
        StringBuilder baseUrl = this.getBaseUrl();
        baseUrl.append("/form/process/");
        baseUrl.append(ref.getReferenceId());
        baseUrl.append("/render");
        try {
            return new URL(baseUrl.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to resolve task dispatch url", e);
        }
    }

    private boolean processHasForm(String id) {
        return this.getStartFormName(id) != null;
    }

    private String getStartFormName(String procDefId) {
        RepositoryService repoService = this.processEngine.getRepositoryService();
        List startActivityNames = repoService.getStartActivityNames(procDefId);
        if (null == startActivityNames) {
            throw new RuntimeException("Unable to resolve start activity names for process: " + procDefId);
        }
        String defaultActitvity = (String)startActivityNames.get(0);
        if (startActivityNames.size() > 1) {
            System.out.println("WARN: More then 1 start activity found. Default to " + defaultActitvity + " to resolve the form name.");
        }
        return repoService.getStartFormResourceName(procDefId, defaultActitvity);
    }

    public DataHandler provideForm(FormAuthorityRef ref) {
        DataHandler result = null;
        RepositoryService repoService = this.processEngine.getRepositoryService();
        String startFormResourceName = this.getStartFormName(ref.getReferenceId());
        if (null == startFormResourceName) {
            throw new IllegalArgumentException("Process " + ref.getReferenceId() + " doesn't provide a start form");
        }
        ProcessDefinition procDef = repoService.createProcessDefinitionQuery().processDefinitionId(ref.getReferenceId()).uniqueResult();
        InputStream template = repoService.getResourceAsStream(procDef.getDeploymentId(), startFormResourceName);
        if (template != null) {
            StringBuilder action = this.getBaseUrl();
            action.append("/form/process/");
            action.append(ref.getReferenceId());
            action.append("/complete");
            HashMap<String, Object> renderContext = new HashMap<String, Object>();
            FormDirective formDirective = new FormDirective();
            formDirective.setAction(action.toString());
            renderContext.put("form", formDirective);
            renderContext.put("outcome", new OutcomeDirective());
            result = this.processTemplate(startFormResourceName, template, renderContext);
        }
        return result;
    }
}

