/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.services;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.jboss.bpm.console.client.model.HistoryActivityInstanceRef;
import org.jboss.bpm.console.client.model.HistoryProcessInstanceRef;
import org.jboss.errai.bus.client.api.ErrorCallback;
import org.jboss.errai.bus.client.api.Message;
import org.jboss.errai.bus.client.api.MessageCallback;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.bus.client.api.builder.MessageReplySendable;
import org.jboss.errai.bus.client.framework.MessageBus;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.api.JbpmException;
import org.jbpm.api.history.HistoryActivityInstance;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.integration.console.JBPMIntegration;
import org.jbpm.integration.console.ModelAdaptor;
import org.jbpm.integration.console.services.HistoryCommands;
import org.jbpm.integration.console.services.HistoryParts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="JBPM_HISTORY_SERVICE")
public class HistoryService
extends JBPMIntegration
implements MessageCallback {
    private MessageBus bus;

    @Inject
    public HistoryService(MessageBus bus) {
        this.bus = bus;
    }

    public void callback(Message message) {
        switch (HistoryCommands.valueOf(message.getCommandType())) {
            case GET_FINISHED_PROCESS_INSTANCES: {
                String definitionId = (String)message.get(String.class, (Enum)HistoryParts.PROCESS_DEFINITION_ID);
                List<HistoryProcessInstanceRef> results = this.getFinishedProcessInstances(definitionId);
                ((MessageReplySendable)MessageBuilder.createConversation((Message)message).subjectProvided().command((Enum)HistoryCommands.GET_FINISHED_PROCESS_INSTANCES).with((Enum)HistoryParts.PROCESS_DEFINITION_ID, (Object)definitionId).with((Enum)HistoryParts.INSTANCE_LIST, results).errorsHandledBy(new ErrorCallback(){

                    public boolean error(Message message, Throwable throwable) {
                        throw new JbpmException("Failed to send message", throwable);
                    }
                })).sendNowWith(this.bus);
                break;
            }
            case GET_PROCESS_INSTANCE_HISTORY: {
                String instanceId = (String)message.get(String.class, (Enum)HistoryParts.PROCESS_INSTANCE_ID);
                List<HistoryActivityInstanceRef> results2 = this.getProcessInstanceHistory(instanceId);
                ((MessageReplySendable)MessageBuilder.createConversation((Message)message).subjectProvided().command((Enum)HistoryCommands.GET_PROCESS_INSTANCE_HISTORY).with((Enum)HistoryParts.PROCESS_INSTANCE_ID, (Object)instanceId).with((Enum)HistoryParts.HISTORY_RECORDS, results2).noErrorHandling()).sendNowWith(this.bus);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command " + message.getCommandType());
            }
        }
    }

    private List<HistoryActivityInstanceRef> getProcessInstanceHistory(String processInstanceId) {
        org.jbpm.api.HistoryService historyService = this.processEngine.getHistoryService();
        List his = historyService.createHistoryActivityInstanceQuery().processInstanceId(processInstanceId).list();
        ArrayList<HistoryActivityInstanceRef> results = new ArrayList<HistoryActivityInstanceRef>();
        for (HistoryActivityInstance t0 : his) {
            results.add(ModelAdaptor.adoptHistoryActivity(t0));
        }
        return results;
    }

    private List<HistoryProcessInstanceRef> getFinishedProcessInstances(String definitionId) {
        org.jbpm.api.HistoryService historyService = this.processEngine.getHistoryService();
        ArrayList<HistoryProcessInstanceRef> results = new ArrayList<HistoryProcessInstanceRef>();
        List his = historyService.createHistoryProcessInstanceQuery().processDefinitionId(definitionId).list();
        for (HistoryProcessInstance t0 : his) {
            if (t0.getEndTime() == null) continue;
            results.add(ModelAdaptor.adoptHistoryProcessInstance(t0));
        }
        return results;
    }
}

