/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.enterprise.internal.ejb;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jbpm.api.Configuration;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.cmd.Command;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.EnvironmentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandExecutorSLSB
implements SessionBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)CommandExecutorSLSB.class.getName());
    protected ProcessEngine processEngine = null;
    protected SessionContext sessionContext;

    public <T> T execute(Command<T> command) {
        log.info("Execute " + command);
        CommandService cmd = (CommandService)this.processEngine.get("txRequiredCommandService");
        return (T)cmd.execute(command);
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void ejbCreate() throws CreateException {
        try {
            InitialContext ctx = new InitialContext();
            this.processEngine = (ProcessEngine)ctx.lookup("java:ProcessEngine");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lookup process engine", e);
        }
    }

    private static boolean isInstance(String className, Object object) {
        for (Class<?> cl = object.getClass(); cl != Object.class; cl = cl.getSuperclass()) {
            if (!cl.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    private static String getConfigResource(Context context) throws NamingException {
        String resource = "jbpm.cfg.xml";
        try {
            resource = (String)context.lookup("java:comp/env/ConfigurationResource");
        }
        catch (NameNotFoundException e) {
            log.debug("configuration resource not set, using default: " + resource);
        }
        return resource;
    }

    private static EnvironmentFactory parseConfig(String resource) {
        log.debug("parsing configuration from " + resource);
        return (EnvironmentFactory)new Configuration().setResource(resource).buildProcessEngine();
    }

    private static void bind(Context context, EnvironmentFactory environmentFactory, String name) {
        try {
            context.bind(name, (Object)environmentFactory);
            log.info("bound " + environmentFactory + " to " + name);
        }
        catch (NamingException e) {
            log.info("WARNING: environment factory binding failed", (Throwable)e);
        }
    }

    public void ejbRemove() {
        this.processEngine = null;
        this.sessionContext = null;
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }
}

