/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.enterprise.internal.ejb;

import java.rmi.RemoteException;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jbpm.enterprise.internal.ejb.ExecuteTimerCmd;
import org.jbpm.enterprise.internal.ejb.LocalCommandExecutor;
import org.jbpm.enterprise.internal.ejb.LocalCommandExecutorHome;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.job.TimerImpl;

public abstract class TimerEB
implements EntityBean,
TimedObject {
    private EntityContext entityContext;
    private LocalCommandExecutor commandExecutor;
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)TimerEB.class.getName());

    public abstract Long getDbid();

    public abstract void setDbid(Long var1);

    public abstract Integer getDbversion();

    public abstract void setDbversion(Integer var1);

    public abstract Date getDueDate();

    public abstract void setDueDate(Date var1);

    public void schedule() {
        this.schedule(this.getDueDate());
    }

    private void schedule(Date dueDate) {
        log.debug("registering timer #" + this.getDbid() + " due " + TimerImpl.formatDueDate((Date)dueDate));
        TimerService timerService = this.entityContext.getTimerService();
        timerService.createTimer(dueDate, null);
    }

    public void setEntityContext(EntityContext entityContext) {
        this.entityContext = entityContext;
    }

    public void unsetEntityContext() {
        this.entityContext = null;
    }

    public void ejbRemove() throws RemoveException, RemoteException {
        this.commandExecutor = null;
    }

    public void ejbActivate() throws RemoteException {
        try {
            InitialContext context = new InitialContext();
            LocalCommandExecutorHome commandExecutorHome = (LocalCommandExecutorHome)context.lookup("java:comp/env/ejb/LocalCommandExecutor");
            context.close();
            this.commandExecutor = commandExecutorHome.create();
        }
        catch (NamingException e) {
            throw new EJBException("error retrieving command executor home", (Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException("error creating command executor", (Exception)((Object)e));
        }
    }

    public void ejbPassivate() throws RemoteException {
        this.commandExecutor = null;
    }

    public void ejbLoad() throws RemoteException {
    }

    public void ejbStore() throws RemoteException {
    }

    public void ejbTimeout(Timer timer) {
        Date nextDueDate = this.commandExecutor.execute(new ExecuteTimerCmd(this.getDbid()));
        if (nextDueDate != null) {
            this.schedule(nextDueDate);
        }
    }
}

