/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.editor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jboss.tools.flow.common.model.Flow;
import org.jboss.tools.flow.common.registry.ElementRegistry;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.FlowWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;
import org.jboss.tools.flow.common.wrapper.Wrapper;
import org.jboss.tools.flow.jpdl4.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JpdlDeserializer {
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public Wrapper deserialize(InputStream is) {
        Wrapper result = null;
        try {
            Document document = documentBuilderFactory.newDocumentBuilder().parse(is);
            result = this.createWrapper(document.getDocumentElement());
        }
        catch (Exception e) {
            Logger.logError("An error occurred while creating the diagram", e);
        }
        return result;
    }

    private Wrapper createWrapper(Element element) {
        PostProcessor postProcessor;
        ChildNodeDeserializer childNodeHandler;
        String elementId = this.getElementId(element.getNodeName());
        if (elementId == null) {
            return null;
        }
        Wrapper result = ElementRegistry.createWrapper((String)elementId);
        if (result == null) {
            return null;
        }
        AttributeDeserializer attributeHandler = this.getAttributeHandler(result);
        if (attributeHandler != null) {
            attributeHandler.deserializeAttributes(result, element);
        }
        if ((childNodeHandler = this.getChildNodeHandler(result)) != null) {
            NodeList nodeList = element.getChildNodes();
            ArrayList<Node> unknownNodeList = new ArrayList<Node>();
            int i = 0;
            while (i < nodeList.getLength()) {
                Wrapper childWrapper = childNodeHandler.deserializeChildNode(result, nodeList.item(i));
                if (childWrapper != null) {
                    childWrapper.getElement().setMetaData("leadingNodes", unknownNodeList);
                    unknownNodeList = new ArrayList();
                } else {
                    unknownNodeList.add(nodeList.item(i));
                }
                ++i;
            }
            result.getElement().setMetaData("trailingNodes", unknownNodeList);
        }
        if ((postProcessor = this.getPostProcessor(result)) != null) {
            postProcessor.postProcess(result);
        }
        return result;
    }

    private PostProcessor getPostProcessor(Wrapper wrapper) {
        if (wrapper instanceof FlowWrapper) {
            return new ProcessPostProcessor();
        }
        return null;
    }

    private AttributeDeserializer getAttributeHandler(Wrapper wrapper) {
        if (wrapper instanceof FlowWrapper) {
            return new ProcessAttributeHandler();
        }
        if (wrapper instanceof NodeWrapper) {
            return new NodeAttributeHandler();
        }
        if (wrapper instanceof ConnectionWrapper) {
            return new ConnectionAttributeHandler();
        }
        return null;
    }

    private ChildNodeDeserializer getChildNodeHandler(Wrapper wrapper) {
        if (wrapper instanceof FlowWrapper) {
            return new ProcessChildNodeHandler();
        }
        if (wrapper instanceof NodeWrapper) {
            return new NodeChildNodeHandler();
        }
        return null;
    }

    private String getElementId(String nodeName) {
        if ("process".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.process";
        }
        if ("start".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.startEvent";
        }
        if ("end".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.terminateEndEvent";
        }
        if ("end-error".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.errorEndEvent";
        }
        if ("end-cancel".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.cancelEndEvent";
        }
        if ("state".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.waitTask";
        }
        if ("hql".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.hqlTask";
        }
        if ("sql".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.sqlTask";
        }
        if ("java".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.javaTask";
        }
        if ("script".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.scriptTask";
        }
        if ("esb".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.serviceTask";
        }
        if ("task".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.humanTask";
        }
        if ("exclusive".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.exclusiveGateway";
        }
        if ("join".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.parallelJoinGateway";
        }
        if ("fork".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.parallelForkGateway";
        }
        if ("transition".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.sequenceFlow";
        }
        return null;
    }

    private NodeWrapper getNamedNode(String name, FlowWrapper flowWrapper) {
        if (name == null) {
            return null;
        }
        for (NodeWrapper nodeWrapper : flowWrapper.getElements()) {
            if (!name.equals(nodeWrapper.getName())) continue;
            return nodeWrapper;
        }
        return null;
    }

    private void addGraphics(ConnectionWrapper wrapper, Element element) {
        String graphics = element.getAttribute("g");
        if (graphics != null) {
            String labelInfo;
            int pos = graphics.lastIndexOf(58);
            String bendpointInfo = null;
            if (pos != -1) {
                labelInfo = graphics.substring(pos + 1);
                bendpointInfo = graphics.substring(0, pos);
            } else {
                labelInfo = graphics;
            }
            if (labelInfo != null) {
                this.addLabelInfo(wrapper, labelInfo);
            }
            if (bendpointInfo != null) {
                this.addBendpointInfo(wrapper, bendpointInfo);
            }
        }
    }

    private void addBendpointInfo(ConnectionWrapper wrapper, String bendpointInfo) {
        StringTokenizer bendpoints = new StringTokenizer(bendpointInfo, ";");
        int index = 0;
        while (bendpoints.hasMoreTokens()) {
            StringTokenizer bendpoint = new StringTokenizer(bendpoints.nextToken(), ",");
            if (bendpoint.countTokens() != 2) {
                Logger.logInfo("Wrong info in attribute 'g' while determining bendpoints.");
                continue;
            }
            int x = this.convertStringToInt(bendpoint.nextToken());
            int y = this.convertStringToInt(bendpoint.nextToken());
            wrapper.addBendpoint(index++, new Point(x, y));
        }
    }

    private void addLabelInfo(ConnectionWrapper wrapper, String labelInfo) {
        StringTokenizer label = new StringTokenizer(labelInfo, ",");
        if (label.countTokens() != 2) {
            Logger.logInfo("Wrong info in attribute 'g' while determining label location.");
        } else {
            int x = this.convertStringToInt(label.nextToken());
            int y = this.convertStringToInt(label.nextToken());
            wrapper.getLabel().setLocation(new Point(x, y));
        }
    }

    private void addGraphics(NodeWrapper wrapper, Element element) {
        String graphics = element.getAttribute("g");
        Rectangle constraint = new Rectangle(0, 0, 80, 40);
        if (graphics != null) {
            StringTokenizer tokenizer = new StringTokenizer(graphics, ",");
            if (tokenizer.countTokens() != 4) {
                Logger.logInfo("Wrong info in attribute 'g' for element '" + element.getNodeName() + "'" + " with name '" + element.getAttribute("name") + "'. Using defaults.");
            } else {
                constraint.x = this.convertStringToInt(tokenizer.nextToken());
                constraint.y = this.convertStringToInt(tokenizer.nextToken());
                constraint.width = this.convertStringToInt(tokenizer.nextToken());
                constraint.height = this.convertStringToInt(tokenizer.nextToken());
            }
        }
        wrapper.setConstraint(constraint);
    }

    private int convertStringToInt(String str) {
        int result = 0;
        try {
            result = new Integer(str);
        }
        catch (NumberFormatException e) {
            Logger.logError("Error while converting " + str + " to an integer.", e);
        }
        return result;
    }

    static interface AttributeDeserializer {
        public void deserializeAttributes(Wrapper var1, Element var2);
    }

    static interface ChildNodeDeserializer {
        public Wrapper deserializeChildNode(Wrapper var1, Node var2);
    }

    class ConnectionAttributeHandler
    extends DefaultAttributeDeserializer {
        ConnectionAttributeHandler() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            if (!(wrapper instanceof ConnectionWrapper)) {
                return;
            }
            ConnectionWrapper connectionWrapper = (ConnectionWrapper)wrapper;
            JpdlDeserializer.this.addGraphics(connectionWrapper, element);
            connectionWrapper.getElement().setMetaData("to", (Object)element.getAttribute("to"));
            connectionWrapper.setPropertyValue((Object)"org.jboss.tools.flow.common.model.name", (Object)element.getAttribute("name"));
        }
    }

    class DefaultAttributeDeserializer
    implements AttributeDeserializer {
        DefaultAttributeDeserializer() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            wrapper.getElement().setMetaData("attributes", (Object)element.getAttributes());
        }
    }

    class NodeAttributeHandler
    extends DefaultAttributeDeserializer {
        NodeAttributeHandler() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            if (!(wrapper instanceof NodeWrapper)) {
                return;
            }
            NodeWrapper nodeWrapper = (NodeWrapper)wrapper;
            JpdlDeserializer.this.addGraphics(nodeWrapper, element);
            nodeWrapper.setName(element.getAttribute("name"));
        }
    }

    class NodeChildNodeHandler
    implements ChildNodeDeserializer {
        NodeChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = null;
            if (!(parent instanceof NodeWrapper)) {
                return result;
            }
            NodeWrapper nodeWrapper = (NodeWrapper)parent;
            ArrayList<ConnectionWrapper> flows = (ArrayList<ConnectionWrapper>)nodeWrapper.getElement().getMetaData("flows");
            if (flows == null) {
                flows = new ArrayList<ConnectionWrapper>();
                nodeWrapper.getElement().setMetaData("flows", flows);
            }
            if (node instanceof Element && (result = JpdlDeserializer.this.createWrapper((Element)node)) != null && result instanceof ConnectionWrapper) {
                flows.add((ConnectionWrapper)result);
            }
            return result;
        }
    }

    static interface PostProcessor {
        public void postProcess(Wrapper var1);
    }

    class ProcessAttributeHandler
    extends DefaultAttributeDeserializer {
        ProcessAttributeHandler() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            if (!(wrapper instanceof FlowWrapper)) {
                return;
            }
            FlowWrapper flowWrapper = (FlowWrapper)wrapper;
            ((Flow)flowWrapper.getElement()).setName(element.getAttribute("name"));
        }
    }

    class ProcessChildNodeHandler
    implements ChildNodeDeserializer {
        ProcessChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = null;
            if (!(parent instanceof FlowWrapper)) {
                return result;
            }
            FlowWrapper flowWrapper = (FlowWrapper)parent;
            if (node instanceof Element && (result = JpdlDeserializer.this.createWrapper((Element)node)) != null && result instanceof NodeWrapper) {
                flowWrapper.addElement((NodeWrapper)result);
            }
            return result;
        }
    }

    class ProcessPostProcessor
    implements PostProcessor {
        ProcessPostProcessor() {
        }

        public void postProcess(Wrapper wrapper) {
            if (!(wrapper instanceof FlowWrapper)) {
                return;
            }
            FlowWrapper flowWrapper = (FlowWrapper)wrapper;
            for (NodeWrapper source : flowWrapper.getElements()) {
                ArrayList flows = (ArrayList)source.getElement().getMetaData("flows");
                if (flows == null) continue;
                for (ConnectionWrapper connectionWrapper : flows) {
                    String to = (String)connectionWrapper.getElement().getMetaData("to");
                    if (to == null) {
                        Logger.logInfo("Ignoring sequenceflow without target");
                        continue;
                    }
                    NodeWrapper target = JpdlDeserializer.this.getNamedNode(to, flowWrapper);
                    if (target == null) {
                        Logger.logInfo("Ignoring unknown target " + to + " while resolving sequenceflow target.");
                        continue;
                    }
                    connectionWrapper.connect(source, target);
                }
            }
        }
    }
}

