/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.editpart;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.graphics.Font;
import org.jboss.tools.flow.common.editpart.CellEditorLocator;
import org.jboss.tools.flow.common.editpart.ConnectionEditPart;
import org.jboss.tools.flow.common.policy.ElementDirectEditManager;
import org.jboss.tools.flow.common.policy.ElementDirectEditPolicy;
import org.jboss.tools.flow.common.policy.LabelGraphicalNodeEditPolicy;
import org.jboss.tools.flow.common.wrapper.LabelWrapper;
import org.jboss.tools.flow.common.wrapper.ModelEvent;
import org.jboss.tools.flow.common.wrapper.ModelListener;
import org.jboss.tools.flow.common.wrapper.Wrapper;

public class LabelEditPart
extends AbstractGraphicalEditPart
implements ModelListener {
    private DirectEditManager manager;

    protected IFigure createFigure() {
        return new Label();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new LabelGraphicalNodeEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ElementDirectEditPolicy());
    }

    protected void refreshVisuals() {
        String text = this.getLabelWrapper().getText();
        Polyline polyline = (Polyline)((ConnectionEditPart)this.getParent()).getConnectionFigure();
        Point location = ((LabelWrapper)this.getModel()).getLocation();
        if (location == null) {
            location = this.calculateInitialLocation(polyline, text);
            ((LabelWrapper)this.getModel()).setLocation(location);
        }
        Label label = (Label)this.getFigure();
        label.setText(text);
        LabelConstraint constraint = new LabelConstraint(text, location, polyline);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
    }

    private Point calculateInitialLocation(Polyline polyline, String text) {
        Dimension textDimension = FigureUtilities.getTextExtents((String)text, (Font)this.figure.getFont());
        return new Point(-(textDimension.width + 5), -(textDimension.height + 5));
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    protected void performDirectEdit() {
        Label label = (Label)this.getFigure();
        if (label == null) {
            return;
        }
        if (this.manager == null) {
            this.manager = new ElementDirectEditManager((GraphicalEditPart)this, new CellEditorLocator(label));
        }
        this.manager.show();
    }

    public LabelWrapper getLabelWrapper() {
        return (LabelWrapper)this.getModel();
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker((EditPart)this){

            protected EditPart getTargetEditPart() {
                return LabelEditPart.this.getParent();
            }
        };
    }

    public void activate() {
        super.activate();
        this.getLabelWrapper().addListener(this);
        if (this.getParent().getModel() instanceof Wrapper) {
            ((Wrapper)this.getParent().getModel()).addListener(this);
        }
    }

    public void deactivate() {
        if (this.getParent().getModel() instanceof Wrapper) {
            ((Wrapper)this.getParent().getModel()).removeListener(this);
        }
        this.getLabelWrapper().removeListener(this);
        super.deactivate();
    }

    public void modelChanged(ModelEvent event) {
        if (event.getChange() == 8 || event.getChange() == 5) {
            this.refreshVisuals();
        }
    }

    private class LabelConstraint
    implements Locator {
        String text;
        Point relativeLocation;
        Polyline polyline;

        public LabelConstraint(String text, Point location, Polyline polyline) {
            this.text = text;
            this.relativeLocation = location;
            this.polyline = polyline;
        }

        public void relocate(IFigure figure) {
            Dimension minimum = FigureUtilities.getTextExtents((String)this.text, (Font)figure.getFont());
            figure.setSize(minimum);
            Point midPoint = this.polyline.getPoints().getMidpoint();
            Point newLocation = this.relativeLocation.getCopy();
            newLocation.translate(midPoint);
            figure.setLocation(newLocation);
        }
    }
}

