/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.wrapper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.jboss.tools.flow.common.wrapper.AbstractWrapper;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.LabelWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionWrapper
extends AbstractWrapper
implements ConnectionWrapper {
    private static final long serialVersionUID = 1L;
    private NodeWrapper source;
    private NodeWrapper target;
    private LabelWrapper label;
    private transient List<Point> bendpoints = new ArrayList<Point>();

    public void localSetSource(NodeWrapper source) {
        this.source = source;
    }

    public void localSetTarget(NodeWrapper target) {
        this.target = target;
    }

    @Override
    public void disconnect() {
        if (this.source == null) {
            throw new IllegalStateException("Can't disconnect, source is null");
        }
        if (this.target == null) {
            throw new IllegalStateException("Can't disconnect, target is null");
        }
        this.source.removeOutgoingConnection(this);
        this.target.removeIncomingConnection(this);
        this.source = null;
        this.target = null;
    }

    @Override
    public void connect(NodeWrapper source, NodeWrapper target) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (this.source != null) {
            throw new IllegalStateException("The source of a connection cannot be changed");
        }
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (this.target != null) {
            throw new IllegalStateException("The target of a connection cannot be changed");
        }
        this.source = source;
        this.target = target;
        source.addOutgoingConnection(this);
        target.addIncomingConnection(this);
    }

    @Override
    public NodeWrapper getSource() {
        return this.source;
    }

    @Override
    public NodeWrapper getTarget() {
        return this.target;
    }

    @Override
    public void addBendpoint(int index, Point point) {
        this.bendpoints.add(index, point);
        this.internalSetBendpoints(this.bendpoints);
        this.notifyListeners(1);
    }

    @Override
    public void removeBendpoint(int index) {
        this.bendpoints.remove(index);
        this.internalSetBendpoints(this.bendpoints);
        this.notifyListeners(1);
    }

    @Override
    public void replaceBendpoint(int index, Point point) {
        this.bendpoints.set(index, point);
        this.internalSetBendpoints(this.bendpoints);
        this.notifyListeners(1);
    }

    protected void internalSetBendpoints(List<Point> bendPoints) {
    }

    public void localSetBendpoints(List<Point> bendpoints) {
        this.bendpoints = bendpoints;
    }

    @Override
    public List<Point> getBendpoints() {
        if (this.bendpoints == null) {
            this.bendpoints = this.internalGetBendpoints();
        }
        return this.bendpoints;
    }

    protected abstract List<Point> internalGetBendpoints();

    @Override
    public void setLabel(LabelWrapper label) {
        this.label = label;
    }

    @Override
    public LabelWrapper getLabel() {
        return this.label;
    }
}

