/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.wrapper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.flow.common.model.Connection;
import org.jboss.tools.flow.common.model.DefaultConnection;
import org.jboss.tools.flow.common.model.Node;
import org.jboss.tools.flow.common.properties.WrapperPropertySource;
import org.jboss.tools.flow.common.wrapper.AbstractConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConnectionWrapper
extends AbstractConnectionWrapper {
    private IPropertySource propertySource;

    public Connection getConnection() {
        return (Connection)this.getElement();
    }

    @Override
    protected List<Point> internalGetBendpoints() {
        return this.stringToBendpoints((String)this.getConnection().getMetaData("bendpoints"));
    }

    @Override
    protected void internalSetBendpoints(List<Point> bendpoints) {
        this.getConnection().setMetaData("bendpoints", this.bendpointsToString(bendpoints));
    }

    private String bendpointsToString(List<Point> bendpoints) {
        if (bendpoints == null) {
            return null;
        }
        String result = "[";
        Iterator<Point> iterator = bendpoints.iterator();
        while (iterator.hasNext()) {
            Point point = iterator.next();
            result = String.valueOf(result) + point.x + "," + point.y + (iterator.hasNext() ? ";" : "");
        }
        result = String.valueOf(result) + "]";
        return result;
    }

    private List<Point> stringToBendpoints(String s) {
        String[] bendpoints;
        ArrayList<Point> result = new ArrayList<Point>();
        if (s == null) {
            return result;
        }
        s = s.substring(1, s.length() - 1);
        String[] stringArray = bendpoints = s.split(";");
        int n = bendpoints.length;
        int n2 = 0;
        while (n2 < n) {
            String bendpoint = stringArray[n2];
            String[] xy = bendpoint.split(",");
            result.add(new Point(new Integer(xy[0]).intValue(), new Integer(xy[1]).intValue()));
            ++n2;
        }
        return result;
    }

    @Override
    public void connect(NodeWrapper source, NodeWrapper target) {
        Node from = (Node)source.getElement();
        Node to = (Node)target.getElement();
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.setTo(to);
            connection.setFrom(from);
        } else {
            this.setElement(this.createConnection(from, to));
        }
        super.connect(source, target);
    }

    protected Connection createConnection(Node from, Node to) {
        DefaultConnection result = new DefaultConnection(from, to);
        if (this.getConnection() != null) {
            result.setMetaData("configurationElement", this.getConnection().getMetaData("configurationElement"));
        }
        return result;
    }

    @Override
    protected IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = new WrapperPropertySource(this);
        }
        return this.propertySource;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }
}

