/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.wrapper;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.flow.common.model.Connection;
import org.jboss.tools.flow.common.model.Node;
import org.jboss.tools.flow.common.properties.DefaultNodeWrapperPropertySource;
import org.jboss.tools.flow.common.strategy.AcceptsIncomingConnectionStrategy;
import org.jboss.tools.flow.common.strategy.AcceptsOutgoingConnectionStrategy;
import org.jboss.tools.flow.common.wrapper.AbstractConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.AbstractNodeWrapper;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.DefaultConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

public class DefaultNodeWrapper
extends AbstractNodeWrapper {
    private AcceptsIncomingConnectionStrategy incomingConnectionStrategy;
    private AcceptsOutgoingConnectionStrategy outgoingConnectionStrategy;
    private DefaultNodeWrapperPropertySource propertySource;

    public void setNode(Node node) {
        this.setElement(node);
    }

    public Node getNode() {
        return (Node)this.getElement();
    }

    public String getId() {
        long id = this.getNode().getId();
        return id == -1L ? null : String.valueOf(this.getNode().getId());
    }

    public String getName() {
        return this.getNode().getName();
    }

    protected void internalSetName(String name) {
        this.getNode().setName(name);
    }

    protected void internalSetConstraint(Rectangle constraint) {
        Node node = this.getNode();
        node.setMetaData("x", constraint.x);
        node.setMetaData("y", constraint.y);
        node.setMetaData("width", constraint.width);
        node.setMetaData("height", constraint.height);
    }

    public Rectangle internalGetConstraint() {
        Node node = this.getNode();
        Integer x = (Integer)node.getMetaData("x");
        Integer y = (Integer)node.getMetaData("y");
        Integer width = (Integer)node.getMetaData("width");
        Integer height = (Integer)node.getMetaData("height");
        return new Rectangle(x == null ? 0 : x, y == null ? 0 : y, width == null ? -1 : width, height == null ? -1 : height);
    }

    public void setAcceptsIncomingConnectionStrategy(AcceptsIncomingConnectionStrategy strategy) {
        this.incomingConnectionStrategy = strategy;
    }

    public void setAcceptsOutgoingConnectionStrategy(AcceptsOutgoingConnectionStrategy strategy) {
        this.outgoingConnectionStrategy = strategy;
    }

    public boolean acceptsIncomingConnection(ConnectionWrapper connectionWrapper, NodeWrapper sourceWrapper) {
        if (connectionWrapper == null || sourceWrapper == null) {
            return false;
        }
        if (this.incomingConnectionStrategy != null) {
            return this.incomingConnectionStrategy.acceptsIncomingConnection((Connection)connectionWrapper.getElement(), (Node)sourceWrapper.getElement());
        }
        return true;
    }

    public boolean acceptsOutgoingConnection(ConnectionWrapper connectionWrapper, NodeWrapper targetWrapper) {
        if (connectionWrapper == null || targetWrapper == null) {
            return false;
        }
        if (this.outgoingConnectionStrategy != null) {
            return this.outgoingConnectionStrategy.acceptsOutgoingConnection((Connection)connectionWrapper.getElement(), (Node)targetWrapper.getElement());
        }
        return true;
    }

    protected void internalAddIncomingConnection(AbstractConnectionWrapper connection) {
        this.getNode().addIncomingConnection("", ((DefaultConnectionWrapper)connection).getConnection());
    }

    protected void internalRemoveIncomingConnection(AbstractConnectionWrapper connection) {
        this.getNode().removeIncomingConnection("", ((DefaultConnectionWrapper)connection).getConnection());
    }

    protected void internalAddOutgoingConnection(AbstractConnectionWrapper connection) {
        this.getNode().addOutgoingConnection("", ((DefaultConnectionWrapper)connection).getConnection());
    }

    protected void internalRemoveOutgoingConnection(AbstractConnectionWrapper connection) {
        this.getNode().removeOutgoingConnection("", ((DefaultConnectionWrapper)connection).getConnection());
    }

    protected IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = new DefaultNodeWrapperPropertySource(this);
        }
        return this.propertySource;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }
}

