/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.command;

import org.eclipse.gef.commands.Command;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

public class ReconnectElementConnectionTargetCommand
extends Command {
    private ConnectionWrapper connection;
    private NodeWrapper oldTarget;
    private NodeWrapper newTarget;
    private NodeWrapper source;

    public boolean canExecute() {
        if (this.connection.getSource().equals(this.newTarget)) {
            return false;
        }
        for (ConnectionWrapper connection : this.newTarget.getIncomingConnections()) {
            if (!connection.getSource().equals(this.source) || connection.getTarget().equals(this.oldTarget)) continue;
            return false;
        }
        return this.newTarget.acceptsIncomingConnection(this.connection, this.source);
    }

    public void execute() {
        if (this.newTarget != null) {
            this.connection.disconnect();
            this.connection.connect(this.source, this.newTarget);
        }
    }

    public void setTarget(NodeWrapper target) {
        this.newTarget = target;
    }

    public void setConnection(ConnectionWrapper connection) {
        this.connection = connection;
        this.source = connection.getSource();
        this.oldTarget = connection.getTarget();
    }

    public void undo() {
        this.connection.disconnect();
        this.connection.connect(this.source, this.oldTarget);
    }

    public void redo() {
        this.connection.disconnect();
        this.connection.connect(this.source, this.newTarget);
    }
}

