/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.figure;

import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.flow.common.figure.AbstractElementFigure;
import org.jboss.tools.flow.common.figure.EllipseElementFigure;
import org.jboss.tools.flow.common.figure.IFigureFactory;
import org.jboss.tools.flow.common.figure.RectangleElementFigure;
import org.jboss.tools.flow.common.figure.RoundedRectangleElementFigure;

public class NodeFigureFactory
implements IFigureFactory {
    private static final HashMap<String, Image> imageMap = new HashMap();
    private static final HashMap<String, Color> colorMap = new HashMap();
    private IConfigurationElement configurationElement;

    public NodeFigureFactory(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
    }

    public IFigure createFigure() {
        Image icon;
        URL url;
        String iconPath;
        AbstractElementFigure result = null;
        IConfigurationElement figureElement = null;
        IConfigurationElement[] children = this.configurationElement.getChildren("node");
        if (children.length == 1 && (children = children[0].getChildren("figure")).length == 1) {
            figureElement = children[0];
        }
        if (figureElement == null) {
            return new RectangleElementFigure();
        }
        if (figureElement.getAttribute("class") != null) {
            try {
                return (IFigure)figureElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        children = figureElement.getChildren();
        result = children.length < 1 ? new RectangleElementFigure() : ("ellipse".equals(children[0].getName()) ? new EllipseElementFigure() : ("rounded-rectangle".equals(children[0].getName()) ? new RoundedRectangleElementFigure() : new RectangleElementFigure()));
        if (figureElement.getAttribute("icon") != null) {
            iconPath = figureElement.getAttribute("icon");
            url = Platform.getBundle((String)figureElement.getContributor().getName()).getEntry(iconPath);
            icon = null;
            if (imageMap.containsKey(url.getPath())) {
                icon = imageMap.get(url.getPath());
            } else {
                icon = ImageDescriptor.createFromURL((URL)url).createImage();
                imageMap.put(url.getPath(), icon);
            }
            result.setIcon(icon);
        } else if (this.configurationElement.getAttribute("figure") != null) {
            iconPath = this.configurationElement.getAttribute("figure");
            url = Platform.getBundle((String)this.configurationElement.getContributor().getName()).getEntry(iconPath);
            icon = null;
            if (imageMap.containsKey(url.getPath())) {
                icon = imageMap.get(url.getPath());
            } else {
                icon = ImageDescriptor.createFromURL((URL)url).createImage();
                imageMap.put(url.getPath(), icon);
            }
            result.setIcon(icon);
        }
        if (figureElement.getAttribute("color") != null) {
            String colorString = figureElement.getAttribute("color");
            Color color = null;
            if (colorMap.containsKey(colorString)) {
                color = colorMap.get(colorString);
            } else {
                try {
                    StringTokenizer tokenizer = new StringTokenizer(colorString, ",");
                    int[] rgb = new int[3];
                    int i = 0;
                    while (tokenizer.hasMoreTokens()) {
                        rgb[i++] = Integer.parseInt(tokenizer.nextToken());
                    }
                    color = new Color((Device)Display.getCurrent(), rgb[0], rgb[1], rgb[2]);
                    colorMap.put(colorString, color);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            result.setColor(color);
        }
        Dimension size = new Dimension(result.getSize());
        if (figureElement.getAttribute("width") != null) {
            try {
                size.width = Integer.parseInt(figureElement.getAttribute("width"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (figureElement.getAttribute("height") != null) {
            try {
                size.height = Integer.parseInt(figureElement.getAttribute("height"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        result.setSize(size);
        return result;
    }
}

