/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.registry;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class LanguageRegistry {
    private static final String languagesExtensionPointId = "org.jboss.tools.flow.common.languages";
    private static HashMap<String, String> languageMap = null;

    private static void initializeRegistry() {
        IConfigurationElement[] configurationElements;
        languageMap = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(languagesExtensionPointId);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String id = configElement.getAttribute("id");
            String editor = configElement.getAttribute("editor");
            if (id != null && editor != null) {
                languageMap.put(editor, id);
            }
            ++n2;
        }
    }

    public static boolean isLanguageRegisteredFor(String editorId) {
        if (languageMap == null) {
            LanguageRegistry.initializeRegistry();
        }
        return languageMap.containsKey(editorId);
    }

    public static String getLanguageRegisteredFor(String editorId) {
        if (languageMap == null) {
            LanguageRegistry.initializeRegistry();
        }
        return languageMap.get(editorId);
    }
}

