/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.model;

import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jboss.tools.flow.jpdl4.model.Task;

public class HumanTask
extends Task {
    private static String ASSIGNMENT_LABEL = "Assignment";
    public static final String ASSIGNMENT_TYPE = "org.jboss.tools.flow.jpdl4.model.task.assignment.type";
    public static final String ASSIGNMENT_EXPRESSION = "org.jboss.tools.flow.jpdl4.model.task.assignment.expression";
    public static final String ASSIGNMENT_EXPRESSION_LANGUAGE = "org.jboss.tools.flow.jpdl4.model.task.assignment.expression.language";
    public static final String ASSIGNEE = "assignee";
    public static final String CANDIDATE_GROUPS = "candidate-groups";
    public static final String SWIMLANE = "swimlane";
    public static final String NONE = "none";
    public static final String[] ASSIGNMENT_TYPES = new String[]{"assignee", "candidate-groups", "swimlane", "none"};
    private String assignmentType = "none";
    private String assignmentExpression = "";
    private String assignmentExpressionLanguage = "";

    public static Integer getAssignmentTypesIndex(String assignmentType) {
        Integer result = 0;
        String[] stringArray = ASSIGNMENT_TYPES;
        int n = ASSIGNMENT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equals(assignmentType)) break;
            result = result + 1;
            ++n2;
        }
        return result;
    }

    public HumanTask() {
        this.setMetaData("propertySource", new PropertySource());
    }

    private class PropertySource
    implements IPropertySource {
        private IPropertyDescriptor[] propertyDescriptors;

        private PropertySource() {
        }

        private void initializePropertyDescriptors() {
            ComboBoxPropertyDescriptor assignmentTypeDescriptor = new ComboBoxPropertyDescriptor((Object)HumanTask.ASSIGNMENT_TYPE, "Type", ASSIGNMENT_TYPES);
            assignmentTypeDescriptor.setCategory(ASSIGNMENT_LABEL);
            TextPropertyDescriptor assignmentExpressionDescriptor = new TextPropertyDescriptor((Object)HumanTask.ASSIGNMENT_EXPRESSION, "Expression");
            assignmentExpressionDescriptor.setCategory(ASSIGNMENT_LABEL);
            TextPropertyDescriptor assignmentExpressionLanguageDescriptor = new TextPropertyDescriptor((Object)HumanTask.ASSIGNMENT_EXPRESSION_LANGUAGE, "Language");
            assignmentExpressionLanguageDescriptor.setCategory(ASSIGNMENT_LABEL);
            this.propertyDescriptors = new IPropertyDescriptor[]{assignmentTypeDescriptor, assignmentExpressionDescriptor, assignmentExpressionLanguageDescriptor};
        }

        public Object getEditableValue() {
            return null;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            if (this.propertyDescriptors == null) {
                this.initializePropertyDescriptors();
            }
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object id) {
            if (HumanTask.ASSIGNMENT_TYPE.equals(id)) {
                return HumanTask.getAssignmentTypesIndex(HumanTask.this.assignmentType);
            }
            if (HumanTask.ASSIGNMENT_EXPRESSION.equals(id)) {
                return HumanTask.this.assignmentExpression;
            }
            if (HumanTask.ASSIGNMENT_EXPRESSION_LANGUAGE.equals(id)) {
                return HumanTask.this.assignmentExpressionLanguage;
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            if (HumanTask.ASSIGNMENT_TYPE.equals(id)) {
                return true;
            }
            if (HumanTask.ASSIGNMENT_EXPRESSION.equals(id)) {
                return !"".equals(HumanTask.this.assignmentExpression);
            }
            if (HumanTask.ASSIGNMENT_EXPRESSION_LANGUAGE.equals(id)) {
                return !"".equals(HumanTask.this.assignmentExpressionLanguage);
            }
            return false;
        }

        public void resetPropertyValue(Object id) {
            if (HumanTask.ASSIGNMENT_TYPE.equals(id)) {
                HumanTask.this.assignmentType = HumanTask.NONE;
            } else if (HumanTask.ASSIGNMENT_EXPRESSION.equals(id)) {
                HumanTask.this.assignmentExpression = "";
            } else if (HumanTask.ASSIGNMENT_EXPRESSION_LANGUAGE.equals(id)) {
                HumanTask.this.assignmentExpressionLanguage = "";
            }
        }

        public void setPropertyValue(Object id, Object value) {
            if (HumanTask.ASSIGNMENT_TYPE.equals(id)) {
                HumanTask.this.assignmentType = ASSIGNMENT_TYPES[(Integer)value];
            } else if (HumanTask.ASSIGNMENT_EXPRESSION.equals(id)) {
                HumanTask.this.assignmentExpression = (String)value;
            } else if (HumanTask.ASSIGNMENT_EXPRESSION_LANGUAGE.equals(id)) {
                HumanTask.this.assignmentExpressionLanguage = (String)value;
            }
        }
    }
}

