/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.properties;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.flow.jpdl4.command.ChangePropertyCommand;
import org.jboss.tools.flow.jpdl4.model.HumanTask;
import org.jboss.tools.flow.jpdl4.properties.JpdlPropertySheetPage;

public class AssignmentSection
extends AbstractPropertySection {
    private CCombo typeCombo;
    private CLabel typeLabel;
    private Text expressionText;
    private CLabel expressionLabel;
    private IPropertySource input;
    private CommandStack commandStack;
    private SelectionListener typeComboSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AssignmentSection.this.changeProperty("org.jboss.tools.flow.jpdl4.model.task.assignment.type", AssignmentSection.this.typeCombo.getSelectionIndex());
            AssignmentSection.this.expressionText.setEnabled(!"none".equals(AssignmentSection.this.typeCombo.getText()));
        }
    };
    private ModifyListener expressionTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AssignmentSection.this.changeProperty("org.jboss.tools.flow.jpdl4.model.task.assignment.expression", AssignmentSection.this.expressionText.getText());
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        if (aTabbedPropertySheetPage instanceof JpdlPropertySheetPage) {
            this.commandStack = ((JpdlPropertySheetPage)aTabbedPropertySheetPage).getCommandStack();
        }
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createTypeLabel(composite);
        this.createTypeCombo(composite);
        this.createExpressionLabel(composite);
        this.createExpressionText(composite);
    }

    private void createTypeLabel(Composite parent) {
        this.typeLabel = this.getWidgetFactory().createCLabel(parent, "Type");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.typeLabel.setLayoutData((Object)data);
    }

    private void createTypeCombo(Composite parent) {
        this.typeCombo = this.getWidgetFactory().createCCombo(parent);
        this.typeCombo.setItems(HumanTask.ASSIGNMENT_TYPES);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 85);
        this.typeCombo.setLayoutData((Object)data);
    }

    private void createExpressionLabel(Composite parent) {
        this.expressionLabel = this.getWidgetFactory().createCLabel(parent, "Expression");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.typeCombo, 4);
        this.expressionLabel.setLayoutData((Object)data);
    }

    private void createExpressionText(Composite parent) {
        this.expressionText = this.getWidgetFactory().createText(parent, "");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.typeCombo, 2);
        data.right = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 80);
        this.expressionText.setLayoutData((Object)data);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object object;
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (object = ((IAdaptable)object).getAdapter(IPropertySource.class)) instanceof IPropertySource) {
            this.input = (IPropertySource)object;
            return;
        }
        this.input = null;
    }

    protected void changeProperty(Object propertyId, Object newValue) {
        if (this.commandStack == null || this.input == null) {
            return;
        }
        Object oldValue = this.input.getPropertyValue(propertyId);
        if (oldValue == newValue) {
            return;
        }
        ChangePropertyCommand changePropertyCommand = new ChangePropertyCommand();
        changePropertyCommand.setPropertyId(propertyId);
        changePropertyCommand.setTarget(this.input);
        changePropertyCommand.setNewValue(newValue);
        this.commandStack.execute((Command)changePropertyCommand);
    }

    protected void unhookListeners() {
        this.typeCombo.removeSelectionListener(this.typeComboSelectionListener);
        this.expressionText.removeModifyListener(this.expressionTextModifyListener);
    }

    protected void hookListeners() {
        this.typeCombo.addSelectionListener(this.typeComboSelectionListener);
        this.expressionText.addModifyListener(this.expressionTextModifyListener);
    }

    protected void updateValues() {
        if (this.input == null) {
            this.typeCombo.setText("none");
            this.expressionText.setEnabled(false);
            this.expressionText.setText("");
        } else {
            this.typeCombo.setText(HumanTask.ASSIGNMENT_TYPES[(Integer)this.input.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.task.assignment.type")]);
            if ("none".equals(this.typeCombo.getText())) {
                this.expressionText.setEnabled(false);
                this.expressionText.setText("");
            } else {
                this.expressionText.setEnabled(true);
                this.expressionText.setText((String)this.input.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.task.assignment.expression"));
            }
        }
    }

    public void aboutToBeShown() {
        this.refresh();
    }

    public void refresh() {
        this.unhookListeners();
        this.updateValues();
        this.hookListeners();
    }
}

