/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jboss.tools.flow.common.model.Container;
import org.jboss.tools.flow.common.model.Element;
import org.jboss.tools.flow.common.model.Flow;
import org.jboss.tools.flow.jpdl4.model.SequenceFlow;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jpdl4Helper {
    private static List<Node> getTrailingNodes(Element element) {
        ArrayList result = (ArrayList)element.getMetaData("trailingNodes");
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    private static List<Node> getLeadingNodes(Element element) {
        ArrayList result = (ArrayList)element.getMetaData("leadingNodes");
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    public static void mergeLeadingNodes(Element toBeRemoved) {
        if (toBeRemoved == null) {
            return;
        }
        List<Node> successorNodes = Jpdl4Helper.getSuccessorNodes(toBeRemoved);
        List<Node> nodesToMerge = Jpdl4Helper.getLeadingNodes(toBeRemoved);
        boolean started = false;
        int i = nodesToMerge.size();
        while (i > 0) {
            Node node = nodesToMerge.get(i - 1);
            if (node.getNodeType() != 3 && !started) {
                started = true;
            }
            if (started) {
                successorNodes.add(0, node);
            }
            if (node.getNodeType() == 3 && !started) {
                started = true;
            }
            --i;
        }
    }

    private static List<Node> getSuccessorNodes(Element element) {
        Element successor = Jpdl4Helper.getSuccessor(element);
        if (successor != null) {
            return Jpdl4Helper.getLeadingNodes(successor);
        }
        Element parent = Jpdl4Helper.getParent(element);
        if (parent != null) {
            return Jpdl4Helper.getTrailingNodes(parent);
        }
        return new ArrayList<Node>();
    }

    private static Element getParent(Element element) {
        if (element instanceof SequenceFlow) {
            return ((SequenceFlow)element).getFrom();
        }
        if (element instanceof org.jboss.tools.flow.common.model.Node) {
            return ((org.jboss.tools.flow.common.model.Node)element).getNodeContainer();
        }
        return null;
    }

    private static Element getSuccessor(Element element) {
        block5: {
            block4: {
                if (!(element instanceof SequenceFlow)) break block4;
                org.jboss.tools.flow.common.model.Node node = ((SequenceFlow)element).getFrom();
                List connections = node.getOutgoingConnections(null);
                int i = 0;
                while (i < connections.size() - 1) {
                    if (connections.get(i) == element) {
                        return (Element)connections.get(i);
                    }
                    ++i;
                }
                break block5;
            }
            if (!(element instanceof org.jboss.tools.flow.common.model.Node)) break block5;
            Container container = ((org.jboss.tools.flow.common.model.Node)element).getNodeContainer();
            List nodes = container.getNodes();
            int i = 0;
            while (i < nodes.size() - 1) {
                if (nodes.get(i) == element) {
                    return (Element)nodes.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static String getLabel(org.jboss.tools.flow.common.model.Node child, Flow container) {
        String label;
        String result = "node";
        IConfigurationElement configurationElement = (IConfigurationElement)child.getMetaData("configurationElement");
        if (configurationElement != null && (label = configurationElement.getAttribute("label")) != null) {
            result = label;
        }
        int runner = 1;
        while (Jpdl4Helper.getNodeByName(String.valueOf(result) + runner, (Container)container) != null) {
            ++runner;
        }
        return String.valueOf(result) + runner;
    }

    private static org.jboss.tools.flow.common.model.Node getNodeByName(String name, Container container) {
        org.jboss.tools.flow.common.model.Node result = null;
        List nodes = container.getNodes();
        for (org.jboss.tools.flow.common.model.Node node : nodes) {
            if (name.equals(node.getName())) {
                result = node;
            }
            if (node instanceof Container) {
                result = Jpdl4Helper.getNodeByName(name, (Container)node);
            }
            if (result != null) break;
        }
        return result;
    }
}

