/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.jboss.tools.flow.common.editor.GenericModelEditor;
import org.jboss.tools.flow.common.registry.ElementRegistry;
import org.jboss.tools.flow.common.wrapper.Wrapper;
import org.jboss.tools.flow.jpdl4.editor.JpdlDeserializer;
import org.jboss.tools.flow.jpdl4.editor.JpdlPaletteFactory;
import org.jboss.tools.flow.jpdl4.editor.JpdlSerializer;
import org.jboss.tools.flow.jpdl4.editpart.JpdlGraphicalEditPartFactory;
import org.jboss.tools.flow.jpdl4.properties.JpdlPropertySheetPage;
import org.jboss.tools.flow.jpdl4.view.DetailsPage;
import org.jboss.tools.flow.jpdl4.view.IDetailsPage;

public class JpdlEditor
extends GenericModelEditor
implements ITabbedPropertySheetPageContributor {
    public static String ID = "org.jboss.tools.flow.jpdl4.editor";
    private DetailsPage detailsPage;

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.writeImage();
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.writeImage();
    }

    protected PaletteRoot createPalette() {
        return new JpdlPaletteFactory().createPalette();
    }

    protected EditPartFactory createEditPartFactory() {
        return new JpdlGraphicalEditPartFactory();
    }

    protected Object createModel() {
        return ElementRegistry.createWrapper((String)"org.jboss.tools.flow.jpdl4.process");
    }

    protected void writeModel(OutputStream os) throws IOException {
        Object object = this.getModel();
        if (object instanceof Wrapper) {
            new JpdlSerializer().serialize((Wrapper)object, os);
        }
    }

    protected void writeImage() {
        SWTGraphics g = null;
        GC gc = null;
        Image image = null;
        LayerManager lm = (LayerManager)this.getGraphicalViewer().getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = lm.getLayer((Object)"Printable Layers");
        try {
            Rectangle r = figure.getBounds();
            image = new Image((Device)Display.getDefault(), r.width, r.height);
            gc = new GC((Drawable)image);
            g = new SWTGraphics(gc);
            g.translate(r.x * -1, r.y * -1);
            figure.paint((Graphics)g);
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{image.getImageData()};
            imageLoader.save(this.getImageSavePath(), 4);
            this.refreshProcessFolder();
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    private String getImageSavePath() {
        IFile file = this.getFile();
        IPath path = file.getRawLocation();
        if ("xml".equals(path.getFileExtension())) {
            path = path.removeFileExtension();
        }
        if ("jpdl".equals(path.getFileExtension())) {
            path = path.removeFileExtension();
        }
        path = path.addFileExtension("png");
        return path.toOSString();
    }

    private void refreshProcessFolder() {
        try {
            IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void createModel(InputStream is) {
        boolean empty = true;
        try {
            empty = is.available() == 0;
        }
        catch (IOException iOException) {}
        this.setModel(empty ? this.createModel() : new JpdlDeserializer().deserialize(is));
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public CommandStack getCommandStack() {
        return super.getCommandStack();
    }

    public DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    protected DetailsPage getDetailsPage() {
        if (this.detailsPage == null) {
            this.initDetailsPage();
        }
        return this.detailsPage;
    }

    protected void initDetailsPage() {
        this.detailsPage = new DetailsPage(this);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.detailsPage);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new JpdlPropertySheetPage(this, this.getCommandStack());
        }
        if (adapter == IDetailsPage.class) {
            return this.getDetailsPage();
        }
        return super.getAdapter(adapter);
    }
}

