/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.editpart;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.jboss.tools.flow.common.editpart.ConnectionEditPart;
import org.jboss.tools.flow.common.figure.DiamondDecoration;
import org.jboss.tools.flow.common.model.Element;
import org.jboss.tools.flow.common.policy.ElementDirectEditPolicy;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.LabelWrapper;
import org.jboss.tools.flow.common.wrapper.ModelEvent;
import org.jboss.tools.flow.common.wrapper.Wrapper;
import org.jboss.tools.flow.jpdl4.editpart.JpdlGraphicalEditPart;
import org.jboss.tools.flow.jpdl4.model.SequenceFlow;

public class SequenceFlowGraphicalEditPart
extends ConnectionEditPart
implements JpdlGraphicalEditPart {
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ElementDirectEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.decorateFigure((PolylineConnection)this.getFigure(), ((Wrapper)this.getModel()).getElement());
    }

    protected IFigure createFigure() {
        return this.decorateFigure((PolylineConnection)super.createFigure(), ((Wrapper)this.getModel()).getElement());
    }

    private IFigure decorateFigure(PolylineConnection figure, Element element) {
        if (element instanceof SequenceFlow) {
            SequenceFlow sequenceFlow = (SequenceFlow)element;
            if (sequenceFlow.isConditional()) {
                if (this.getElementConnection().getSource().getOutgoingConnections().size() > 1) {
                    figure.setSourceDecoration((RotatableDecoration)new DiamondDecoration());
                }
            } else {
                figure.setSourceDecoration(null);
            }
        }
        return figure;
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    protected void performDirectEdit() {
        EditPart editPart;
        ConnectionWrapper connectionWrapper = this.getElementConnection();
        LabelWrapper labelWrapper = connectionWrapper.getLabel();
        if (labelWrapper != null && (editPart = (EditPart)this.getViewer().getEditPartRegistry().get(labelWrapper)) != null) {
            editPart.performRequest((Request)new DirectEditRequest());
        }
    }

    public void modelChanged(ModelEvent event) {
        this.refresh();
    }
}

