/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.properties;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.flow.jpdl4.properties.JpdlPropertySection;

public class TextFieldPropertySection
extends JpdlPropertySection {
    private Text propertyText;
    private CLabel propertyLabel;
    private String name;
    private String label;
    private ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            TextFieldPropertySection.this.changeProperty(TextFieldPropertySection.this.name, TextFieldPropertySection.this.getValueNullsAllowed(TextFieldPropertySection.this.propertyText.getText()));
        }
    };

    public TextFieldPropertySection(String name, String label) {
        this.name = name;
        this.label = label;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getFlatFormComposite();
        this.createPropertyLabel(composite);
        this.createPropertyText(composite);
    }

    private void createPropertyLabel(Composite parent) {
        this.propertyLabel = this.getWidgetFactory().createCLabel(parent, this.label);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 5);
        this.propertyLabel.setLayoutData((Object)data);
    }

    private void createPropertyText(Composite parent) {
        this.propertyText = this.getWidgetFactory().createText(parent, "");
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(30, 0);
        data.right = new FormAttachment(100, 0);
        this.propertyText.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        this.propertyText.addModifyListener(this.textModifyListener);
    }

    protected void unhookListeners() {
        this.propertyText.removeModifyListener(this.textModifyListener);
    }

    protected void updateValues() {
        IPropertySource input = this.getInput();
        if (input != null) {
            this.propertyText.setText(this.getValueNotNull((String)input.getPropertyValue((Object)this.name)));
        } else {
            this.propertyText.setText("");
        }
    }
}

